% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggfluxes.R
\name{agg.fluxes}
\alias{agg.fluxes}
\title{Accumulation of fluxes}
\usage{
agg.fluxes(fluxes, datetimes, timeunit = "hours")
}
\arguments{
\item{fluxes}{flux values}

\item{datetimes}{datetime values (POSIXct or POSIXlt)}

\item{timeunit}{the unit of time (denominator of the flux unit), supported are the explicit units supported by \code{difftime}}
}
\value{
A one-row data.frame with columns
   \item{flux}{the cumulative flux}
   \item{from}{the start of the cumulation period}
   \item{to}{the end of the cumulation period}
 The return value being a data.frame is useful, when the function is used for "split-apply-combine" type operations to calculate groupwise cumulated values, 
 e.g., using package data.table.
}
\description{
Aggregate a time series of fluxes to a cummulative flux value.
}
\details{
The function uses linear interpolation. The unit of the cumulative flux is [fluxes] * timeunit. 
NA values are removed and values sorted according to time order. If less then two non-NA value pairs are provided, 
NA is returned for the cumlative flux.
}
\examples{
#Some random example data
datetimes <- Sys.time() + (1:20)/2*24*3600
set.seed(42)
fluxes <- rlnorm(20, 5)
agg.fluxes(fluxes, datetimes)

}
