% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_chomp.R
\name{data_chomp}
\alias{data_chomp}
\title{Subset Data - Get species, longitude, and latitude columns}
\usage{
data_chomp(
  df,
  accepted.name = NA,
  longitude = "longitude",
  latitude = "latitude"
)
}
\arguments{
\item{df}{Data frame of occurrence records returned from \code{gators_download()}.}

\item{accepted.name}{The accepted species name for the records.}

\item{longitude}{Default = "longitude". The name of the longitude column in the data frame.}

\item{latitude}{Default = "latitude". The name of the latitude column in the data frame.}
}
\value{
Returns data frame with a subset of columns ready for downstream applications such as Maxent.
}
\description{
The \code{data_chomp()} function "chomps" (subsets) a data frame of occurrence records to only
contain the following columns: "species", "longitude", and "latitude". After using this
function data will be ready for use in Maxent, for example.
}
\details{
This function requires the package dplyr.
}
\examples{
chomped_data <- data_chomp(data, accepted.name = "Galax urceolata")

}
