% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lag.R
\name{get_lag}
\alias{get_lag}
\title{Get timelag}
\usage{
get_lag(x, time, tau = 1, treatment = NULL, mindt = 0, maxdt = Inf)
}
\arguments{
\item{x}{The time series from which time lagged observations are desired (e.g. population sizes)}

\item{time}{The time steps corresponding to each observation}

\item{tau}{Number of time steps to use between lagged components - defaults to 1}

\item{treatment}{An optional vector of treatment conditions - time lags will only be computed separately within treatments - defaults to NULL (i.e. no treatments)}

\item{mindt}{Minimum dt allowed between observations - defaults to 0}

\item{maxdt}{Maximum dt allowed between observations - defaults to Inf}
}
\value{
Returns a data.frame with 7 columns: x (unlagged time series data); laggedx (lagged time series data); xmid (average of time series and lagged time series values);
dt (time lag between x and laggedx); time (time for observation x); laggedtime (time for observation laggedx); treatment (treatment for observation)
}
\description{
Calculates time-lagged observations for variable x, separated by treatment.
}
\examples{
data(gause_1934_science_f02_03)
lagged_data <- get_lag(x=gause_1934_science_f02_03$Volume_Species1,
               time = gause_1934_science_f02_03$Day,
               treatment = gause_1934_science_f02_03$Treatment)
}
\concept{Gause}
\concept{competition}
\concept{lag}
\concept{time}
