% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbp2d_cpp_rd.r
\docType{class}
\name{gbp2d}
\alias{Rcpp_gbp2d}
\alias{Rcpp_gbp2d-class}
\alias{gbp2d}
\title{gbp2d}
\format{An object of class \code{C++Class} of length 1.}
\usage{
gbp2d
}
\description{
generalized bin packing problem in 2 dimension, a.k.a rectangle fill.
}
\details{
gbp2d init a profit vector p, a length vector l, a depth vector d,
  a length constraint ml, and a depth constraint md on l x d rectangle
  with geometry intepretation.

 gbp2d solver would solve

   maximize   sum_{j=1}^{n} p_{j} k_{j}

   subject to fit (l_{j}, d_{j}) at coordinate (x_{j}, y_{j})
              such that no overlap in ml x md, j = 1, ...., n

 and instantiate a gbp2d object with a x-axis coordinate vector x, a y-axis coordinate vector y,
  a selection vector k, and an objective o.

 a gbp2d class instance has 6 fields:

  - p: profit of it fit into bn <vector>

       created via cluster max(l, d) and min(l, d) via gbp2d_solver_dpp_prep_create_p()

  - it: it position and scale <matrix>

    - x, y it position in the bin <numeric>

    - l, d it scale along x and y <numeric>

  - bn: bn scale <vector>

    - l, d bn scale along x and y <numeric>

  - k: selection indicator 0, 1 <vector>

  - o: objective achivement volumn fit in over volumn overall <numeric>

  - ok: a quick indicator of all it fit into bn? <bool>
}
\note{
p is a proxy of ranking on rectangle fit difficulty, often a function w.r.t max(l, d) and l x d
}
\seealso{
Other gbp2d: \code{\link{gbp2d_checkr}},
  \code{\link{gbp2d_solver_dpp}}
}
\keyword{datasets}

