hsvmpath <- function(x, y, nlam, flmin, ulam, isd, 
    eps, dfmax, pmax, jd, pf, maxit, lam2, delta, nobs, nvars, 
    vnames) {
    #################################################################################
    #data setup
    y <- as.factor(y)
    y <- c(-1, 1)[as.numeric(y)]
    if (!all(y %in% c(-1, 1))) 
        stop("y should be a factor with two levels")
    if (delta < 0) 
        stop("delta must be non-negative")
    delta <- as.double(delta)
    #################################################################################
    # call Fortran core
    fit <- .Fortran("hsvmlassoNET", delta, lam2, nobs, nvars, 
        as.double(x), as.double(y), jd, pf, dfmax, pmax, nlam, 
        flmin, ulam, eps, isd, maxit, nalam = integer(1), b0 = double(nlam), 
        beta = double(pmax * nlam), ibeta = integer(pmax), nbeta = integer(nlam), 
        alam = double(nlam), npass = integer(1), jerr = integer(1), 
        PACKAGE = "gcdnet")
    #################################################################################
    # output
    outlist <- getoutput(fit, maxit, pmax, nvars, vnames)
    outlist <- c(outlist, list(npasses = fit$npass, jerr = fit$jerr))
    class(outlist) <- c("hsvmpath")
    outlist
} 
