% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{gchart_set_cache}
\alias{gchart_set_cache}
\title{Set up a cache directory}
\usage{
gchart_set_cache(
  path = tools::R_user_dir(package = "gchartsmap", which = "cache"),
  install = FALSE,
  overwrite = FALSE,
  home = "HOME"
)
}
\arguments{
\item{path}{Path to use for the package cache.}

\item{install}{if TRUE, will install the cache path in your \code{.Renviron}
file for use in future sessions. Defaults to FALSE.}

\item{overwrite}{If this is set to TRUE, it will overwrite an existing
cache path that you already have in your \code{.Renviron} file.}

\item{home}{Path for the \code{.Renviron} file. Defaults to "HOME".}
}
\value{
Sets and returns the path to the cache where downloaded data will be
stored. Is used for the side effect of setting the `R_GOOGLE_CHART_CACHE`
environment variable, and can store the path in `.Renviron` for use in
future R sessions if requested.
}
\description{
Ensures that the directory exists and sets the environment
    variable for access.
}
\examples{

library(package = "gchartsmap")

# set the cache path to your system's cache path
gchartsmap::gchart_set_cache()

\donttest{
# save the cache path in your home .Renviron file
gchartsmap::gchart_set_cache(install = TRUE)
}

}
