\name{gdal_chooseInstallation}
\alias{gdal_chooseInstallation}
\title{gdal_chooseInstallation}
\usage{
gdal_chooseInstallation(hasDrivers)
}
\arguments{
  \item{hasDrivers}{Character. Which drivers must be
  available?}
}
\value{
Numeric id of the most recent installation that matches the
requirements.
}
\description{
Choose a GDAL installation based on certain requirements.
}
\details{
By default, the GDAL commands will use the installation
found at getOption("gdalUtils_gdalPath")[[1]], which is the
most recent version found on the system.  If the user has
more than one GDAL installed (more common on Windows and
Mac systems than *nix systems), gdal_chooseInstallation can
be used to choose an installation (perhaps not the most
recent one) that has certain functionality, e.g. supports
HDF4 formatted files.
}
\examples{
\dontrun{
# Choose the best installation that has both HDF4 and HDF5 drivers:
gdal_chooseInstallation(hasDrivers=c("HDF4","HDF5"))
# Get the version of this installation:
getOption("gdalUtils_gdalPath")[[
	gdal_chooseInstallation(hasDrivers=c("HDF4","HDF5"))]]$version
}
}
\author{
Jonathan A. Greenberg (\email{gdalUtils@estarcion.net})
}
\references{
\url{http://www.gdal.org/gdal_translate.html}
}

