% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{transform_xy}
\alias{transform_xy}
\title{Transform geospatial x/y coordinates}
\usage{
transform_xy(pts, srs_from, srs_to)
}
\arguments{
\item{pts}{Numeric array of geospatial x/y coordinates}

\item{srs_from}{Character string in OGC WKT format specifying the
spatial reference system for \code{pts}.}

\item{srs_to}{Character string in OGC WKT format specifying the output
spatial reference system.}
}
\value{
Numeric array of geospatial x/y coordinates in the projection
specified by \code{srs_to}.
}
\description{
\code{transform_xy()} transforms geospatial x/y coordinates to a new projection.
}
\note{
\code{transform_xy()} is included here as a convenience function mainly for
internal use. See package \code{sf} for more full-featured
coordinate transformation (\url{https://r-spatial.github.io/sf/}).
}
\examples{
pt_file <- system.file("extdata/storml_pts.csv", package="gdalraster")
pts <- read.csv(pt_file)
## id, x, y in NAD83 / UTM zone 12N
## transform to NAD83 / CONUS Albers
transform_xy( pts = as.matrix(pts[,-1]), 
              srs_from = epsg_to_wkt(26912), 
              srs_to = epsg_to_wkt(5070) )
}
\seealso{
\code{\link[=epsg_to_wkt]{epsg_to_wkt()}}, \code{\link[=srs_to_wkt]{srs_to_wkt()}}, \code{\link[=inv_project]{inv_project()}}
}
