% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vsi_rmdir}
\alias{vsi_rmdir}
\title{Delete a directory}
\usage{
vsi_rmdir(path)
}
\arguments{
\item{path}{Character string. The path to the directory to be deleted.}
}
\value{
Invisibly, \code{0} on success or \code{-1} on an error.
}
\description{
\code{vsi_rmdir()} deletes a directory object from the file system. On some
systems the directory must be empty before it can be deleted.
This function goes through the GDAL \code{VSIFileHandler} virtualization and may
work on unusual filesystems such as in memory.
It is a wrapper for \code{VSIRmdir()} in the GDAL Common Portability Library.
Analog of the POSIX \code{rmdir()} function.
}
\examples{
# for illustration only
# this would normally be used with GDAL virtual file systems
new_dir <- file.path(tempdir(), "newdir")
result <- vsi_mkdir(new_dir)
print(result)
result <- vsi_rmdir(new_dir)
print(result)
}
\seealso{
\code{\link[=deleteDataset]{deleteDataset()}}, \code{\link[=vsi_mkdir]{vsi_mkdir()}}, \code{\link[=vsi_read_dir]{vsi_read_dir()}}, \code{\link[=vsi_unlink]{vsi_unlink()}}
}
