% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{srs_to_wkt}
\alias{srs_to_wkt}
\title{Convert various spatial reference formats to Well Known Text}
\usage{
srs_to_wkt(srs, pretty = FALSE)
}
\arguments{
\item{srs}{Character string containing an SRS definition in various
formats (see Details).}

\item{pretty}{Logical. \code{TRUE} to return a nicely formatted WKT string
for display to a person. \code{FALSE} for a regular WKT string (the default).}
}
\value{
Character string containing OGC WKT.
}
\description{
\code{srs_to_wkt()} converts a spatial reference system (SRS) definition
in various text formats to WKT. The function will examine the input SRS,
try to deduce the format, and then export it to WKT.
}
\details{
This is a wrapper for \code{OSRSetFromUserInput()} in the GDAL Spatial
Reference System C API with output to WKT.
The input SRS may take the following forms:
\itemize{
\item WKT - to convert WKT versions (see below)
\item EPSG:n - EPSG code n
\item AUTO:proj_id,unit_id,lon0,lat0 - WMS auto projections
\item urn:ogc:def:crs:EPSG::n - OGC URNs
\item PROJ.4 definitions
\item filename - file to read for WKT, XML or PROJ.4 definition
\item well known name such as NAD27, NAD83, WGS84 or WGS72
\item IGNF:xxxx, ESRI:xxxx - definitions from the PROJ database
\item PROJJSON (PROJ >= 6.2)
}

This function is intended to be flexible, but by its nature it is
imprecise as it must guess information about the format intended.
\code{\link[=epsg_to_wkt]{epsg_to_wkt()}} could be used instead for EPSG codes.

As of GDAL 3.0, the default format for WKT export is OGC WKT 1.
The WKT version can be overridden by using the OSR_WKT_FORMAT
configuration option (see \code{\link[=set_config_option]{set_config_option()}}).
Valid values are one of: SFSQL, WKT1_SIMPLE, WKT1, WKT1_GDAL,
WKT1_ESRI, WKT2_2015, WKT2_2018, WKT2, DEFAULT.
If SFSQL, a WKT1 string without AXIS, TOWGS84, AUTHORITY or
EXTENSION node is returned. If WKT1_SIMPLE, a WKT1 string without
AXIS, AUTHORITY or EXTENSION node is returned. WKT1 is an alias of
WKT1_GDAL. WKT2 will default to the latest revision implemented
(currently WKT2_2018). WKT2_2019 can be used as an alias of
WKT2_2018 since GDAL 3.2
}
\examples{
srs_to_wkt("NAD83")
writeLines(srs_to_wkt("NAD83", pretty=TRUE))
set_config_option("OSR_WKT_FORMAT", "WKT2")
writeLines(srs_to_wkt("NAD83", pretty=TRUE))
set_config_option("OSR_WKT_FORMAT", "")
}
\seealso{
\code{\link[=epsg_to_wkt]{epsg_to_wkt()}}
}
