% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bbox_to_wkt}
\alias{bbox_to_wkt}
\title{Convert a bounding box to POLYGON in OGC WKT format.}
\usage{
bbox_to_wkt(bbox)
}
\arguments{
\item{bbox}{Numeric vector of length four containing xmin, ymin,
xmax, ymax.}
}
\value{
Character string for an OGC WKT polygon. An empty string is
returned if GDAL was built without the GEOS library.
}
\description{
\code{bbox_to_wkt()} returns a WKT POLYGON string for the given bounding box.
This function requires GDAL built with the GEOS library.
}
\examples{
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
ds <- new(GDALRaster, elev_file, read_only=TRUE)
bbox_to_wkt(ds$bbox())
ds$close()
}
\seealso{
\code{\link[=bbox_from_wkt]{bbox_from_wkt()}}
}
