% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_swap_xy}
\alias{g_swap_xy}
\title{Swap geometry x and y coordinates}
\usage{
g_swap_xy(
  geom,
  as_wkb = TRUE,
  as_iso = FALSE,
  byte_order = "LSB",
  quiet = FALSE
)
}
\arguments{
\item{geom}{Either a raw vector of WKB or list of raw vectors, or a
character vector containing one or more WKT strings.}

\item{as_wkb}{Logical value, \code{TRUE} to return the output geometry in WKB
format (the default), or \code{FALSE} to return as WKT.}

\item{as_iso}{Logical value, \code{TRUE} to export as ISO WKB/WKT (ISO 13249
SQL/MM Part 3), or \code{FALSE} (the default) to export as "Extended WKB/WKT".}

\item{byte_order}{Character string specifying the byte order when output is
WKB. One of \code{"LSB"} (the default) or \code{"MSB"} (uncommon).}

\item{quiet}{Logical value, \code{TRUE} to suppress warnings. Defaults to \code{FALSE}.}
}
\value{
A geometry as WKB raw vector or WKT string, or a list/character vector of
geometries as WKB/WKT with length equal to \code{length(geom)}. \code{NA} is returned
with a warning if WKB input cannot be converted into an OGR geometry object.
}
\description{
\code{g_swap_xy()} swaps x and y coordinates of the input geometry.
Wrapper of \code{OGR_G_SwapXY()} in the GDAL API.
}
\examples{
g <- "GEOMETRYCOLLECTION(POINT(1 2),
                         LINESTRING(1 2,2 3),
                         POLYGON((0 0,0 1,1 1,0 0)))"

g_swap_xy(g, as_wkb = FALSE)
}
