% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdi.r
\name{measuresil}
\alias{measuresil}
\title{Take pixel-by-pixel measurements of a silhouette in jpeg or png format for use with the gdi function.}
\usage{
measuresil(
  image_file,
  threshold = 0.5,
  channel = 4,
  method = "greater",
  align = "h",
  return = "diameters"
)
}
\arguments{
\item{image_file}{Image to be read. Images can be jpeg or png files, or a previously read image saved as an object in R.}

\item{threshold}{Reference value for colour criterium after which pixels that are part of the silhouette are differentiated from the background.}

\item{channel}{Colour channel to which to apply the threshold criterium. Default is 4 (alpha channel of rgba image). Channel setting needs to be adjusted depending on the colour mode of the image used (e.g. there are two channels to choose from in a greyscale image with transparency, and 3 in an rgb image without transparency, or 4 in a full rgba image).}

\item{method}{Method for determining which pixels to count. Default "greater" counts pixels with value greater than threshold (e.g. higher opacity, in the case of an alpha channel). "less" counts pixels with a value less than the threshold. "not" counts all pixels not precisely matching threshold. Any other character string results in only pixels exactly matching the value given as threshold being counted.}

\item{align}{Indicate whether the silhouette long axis is aligned horizontally (setting "h", default), or vertically (any other parameter setting).}

\item{return}{Setting for what to return, default setting ("diameters") returns a single vector containing the diameters, any other setting returns a data frame containing centers and diameters.}
}
\value{
A numeric vector giving the measurements of the silhouette
}
\description{
Take pixel-by-pixel measurements of a silhouette in jpeg or png format for use with the gdi function.
}
\examples{
fdir <- system.file(package="gdi")
lat <- measuresil(file.path(fdir,"exdata","lat.png"))
}
