\name{plotglyph}
\alias{plotglyph}
\concept{ Visualization }
\concept{ Glyphs }
\title{ 3D Glyph Visualization } 

\description{
The ODF profiles reconstructed at each voxel by GQI are visualized as 3D glyphs using \pkg{rgl}.
The estimated fibre orientations per voxel are also depicted.
}

\usage{
plotglyph(odf, grad, pk, kdir=6, vmfglyph=TRUE, pos=c(0,0,0))
}

\arguments{
\item{odf}{ slice ODFs. } 
\item{grad}{ ODF vertices generated by the selected shell tessellation. }
\item{pk}{ coordinates of voxel main directions. }
\item{kdir}{ maximum number of directions to use (default: 6). }
\item{vmfglyph}{ logical variable for glyph visualization in two situations: statistical vMF glyphs (default: \code{TRUE}), and deterministic glyphs. }
\item{pos}{ 3D positional coordinate (default \code{c(0,0,0)}). }
}

\details{
\code{plotglyph} is used by \code{gqi.odfvxgrid}, \code{gqi.odfpeaklines}, and \code{gqi.odfvmflines}. 
}

\references{
Ferreira da Silva, A. R. Facing the Challenge of Estimating Human Brain White Matter Pathways. In \emph{Proc. of the 4th International Joint Conference on Computational Intelligence} (Oct. 2012), K. Madani, J. Kacprzyk, and J. Filipe, Eds., SciTePress, pp. 709-714.

Adler, D., and Murdoch, D. \pkg{rgl}: 3D visualization device system (OpenGL), 2012. R package version 0.92.880.

Auguie, B. \pkg{gridExtra}: functions in Grid graphics, 2012. R package version 0.9.1.

Barber, C. B., Habel, K., Grasman, R., Gramacy, R. B., Stahel, A., and Sterratt, D. C. \pkg{geometry}: Mesh generation and surface tesselation, 2012. R package version 0.3-2.
} 

\author{ Adelino Ferreira da Silva, Universidade Nova de Lisboa,
  Faculdade de Ciencias e Tecnologia, Portugal, \email{afs at fct.unl.pt}
}

\seealso{
  \code{\link{simulglyph.vmf}},
  \code{\link{simulglyph.vmf}},
  \code{\link{gqi.odfpeaks}},
  \code{\link{gqi.odfvmf}},
  \code{\link{gqi.odfvmflines}},
  \code{\link{gqi.odfvxgrid}},
  \code{\link{s2tessel.zorder}},
  \code{\link{plotglyph}},
  \code{\link{rgbvolmap}}
}

\examples{
\dontrun{
    gqi.odfvmflines(showglyph=TRUE, thr=0.7)
    ## noise-free simulations and vMF estimation (2 directions)
    simulglyph.vmf(angles=c(20,110),b=1500)
}
}

\keyword{ dplot }

