% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdns-package.r
\docType{package}
\name{gdns}
\alias{gdns}
\title{Tools to Work with Google DNS Over HTTPS API}
\description{
Traditional DNS queries and responses are sent over UDP or TCP without
encryption. This is vulnerable to eavesdropping and spoofing (including
DNS-based Internet filtering). Responses from recursive resolvers to clients
are the most vulnerable to undesired or malicious changes, while
communications between recursive resolvers and authoritative nameservers
often incorporate additional protection.\cr
\cr
To address this problem, Google Public DNS offers DNS resolution over an
encrypted HTTPS connection. DNS-over-HTTPS greatly enhances privacy and
security between a client and a recursive resolver, and complements DNSSEC
to provide end-to-end authenticated DNS lookups.\cr
\cr
Support for reverse lookups is also provided.\cr
\cr
See \url{https://developers.google.com/speed/public-dns/docs/dns-over-https}
for more information.
}
\author{
Bob Rudis (bob@rud.is)
}
