% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp.R
\name{esp}
\alias{esp}
\title{enhanced stratified power(ESP) model}
\usage{
esp(
  formula,
  data,
  wt = NULL,
  discvar = NULL,
  discnum = 10,
  overlaymethod = "and",
  minsize = 1,
  cores = 1,
  alpha = 0.95
)
}
\arguments{
\item{formula}{A formula of ESP model.}

\item{data}{A data.frame, tibble or sf object of observation data.}

\item{wt}{(optional) The spatial weight matrix. When \code{data} is not an \code{sf} object, must provide \code{wt}.}

\item{discvar}{(optional) Name of continuous variable columns that need to be discretized. Noted that
when \code{formula} has \code{discvar}, \code{data} must have these columns. By default, all independent variables are
used as \code{discvar}.}

\item{discnum}{A numeric vector of discretized classes of columns that need to be discretized.
Default all \code{discvar} use \code{10}.}

\item{overlaymethod}{(optional) Spatial overlay method. One of \code{and}, \code{or}, \code{intersection}.
Default is \code{and}.}

\item{minsize}{(optional) The min size of each discretization group. Default all use \code{1}.}

\item{cores}{(optional) Positive integer(default is 1). If cores > 1, use \code{python} \code{joblib} package to
parallel computation.}

\item{alpha}{(optional) Specifies the size of confidence level. Default is \code{0.95}.}
}
\value{
A list with ESP model result.
\describe{
\item{\code{factor}}{results of ESP model factor detection}
\item{\code{interaction}}{results of ESP model interaction detection}
\item{\code{risk1}}{whether values of the response variable between a pair of overlay zones are significantly different}
\item{\code{risk2}}{risk detection result of the input data}
\item{\code{psd}}{power of spatial determinants}
\item{\code{spd}}{shap power of determinants}
\item{\code{determination}}{determination of the optimal interaction of variables}
\item{\code{number_individual_explanatory_variables}}{the number of individual explanatory variables used for examining the interaction effects}
\item{\code{number_overlay_zones}}{the number of overlay zones}
\item{\code{percentage_finely_divided_zones}}{the percentage of finely divided zones that are determined by the interaction of variables}
}
}
\description{
Function for enhanced stratified power model.
}
\note{
Please set up python dependence and configure \code{GDVERSE_PYTHON} environment variable if you want to run \code{rgd()}.
See \code{vignette('rgdrid',package = 'gdverse')} for more details.
}
\examples{
\dontrun{
## The following code needs to configure the Python environment to run:
data('sim')
sim1 = sf::st_as_sf(sim,coords = c('lo','la'))
g = esp(y ~ ., data = sim1, discnum = 5)
}
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
