% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psd_spade.R
\name{psmd_spade}
\alias{psmd_spade}
\title{power of spatial and multilevel discretization determinant(PSMD)}
\usage{
psmd_spade(
  formula,
  data,
  wt = NULL,
  locations = NULL,
  discnum = NULL,
  discmethod = NULL,
  cores = 1,
  seed = 123456789,
  ...
)
}
\arguments{
\item{formula}{A formula of calculate power of spatial and multilevel discretization determinant \code{PSMDQ_s}.}

\item{data}{A data.frame or tibble of observation data.}

\item{wt}{(optional) The spatial weight matrix. When \code{wt} is not provided, must provide \code{locations},
then \code{gdverse} will use \code{locations} columns to construct spatial weight use \code{inverse_distance_weight()}.}

\item{locations}{(optional) The geospatial locations coordinate columns name which in \code{data}.
Useful and must provided when \code{wt} is not provided.}

\item{discnum}{(optional) Number of multilevel discretization.Default will use \code{3:22}.}

\item{discmethod}{(optional) The discretization methods. Default will use \code{quantile}.
If \code{discmethod} is set to \code{robust}, the function \code{robust_disc()} will be used. Conversely,
if \code{discmethod} is set to \code{rpart}, the \code{rpart_disc()} function will be used. Others use
\code{st_unidisc()}. Currently, only one \code{discmethod} can be used at a time.}

\item{cores}{(optional) A positive integer(default is 1). If cores > 1, use parallel computation.}

\item{seed}{(optional) Random seed number, default is \code{123456789}.}

\item{...}{(optional) Other arguments passed to \code{st_unidisc()},\code{robust_disc()} or \code{rpart_disc()}.}
}
\value{
A value of power of spatial and multilevel discretization determinant \code{PSMDQ_s}.
}
\description{
Function for calculate power of spatial and multilevel discretization determinant \code{PSMDQ_s}.
}
\details{
The power of spatial and multilevel discretization determinant formula is
\eqn{PSMDQ_s = MEAN(Q_s)}
}
\examples{
data('sim')
psmd_spade(y ~ .,
           data = dplyr::select(sim,1:4),
           locations = c('lo','la'))

}
\references{
Xuezhi Cang & Wei Luo (2018) Spatial association detector (SPADE),International
Journal of Geographical Information Science, 32:10, 2055-2075, DOI:  10.1080/13658816.2018.1476693
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
