% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lesh.R
\name{lesh}
\alias{lesh}
\title{locally explained heterogeneity(LESH) model}
\usage{
lesh(formula, data, cores = 1, ...)
}
\arguments{
\item{formula}{A formula of LESH model.}

\item{data}{A data.frame, tibble or sf object of observation data.}

\item{cores}{(optional) Positive integer (default is 1). When cores are greater than 1, use
multi-core parallel computing.}

\item{...}{(optional) Other arguments passed to \code{rpart_disc()}.}
}
\value{
A list.
\describe{
\item{\code{interaction}}{the interaction result of LESH model}
\item{\code{spd_lesh}}{a tibble of the SHAP power of determinants}
}
}
\description{
Function for locally explained heterogeneity model.
}
\note{
The LESH model requires at least \eqn{2^n-1} calculations when has \eqn{n} explanatory variables.
When there are more than 10 explanatory variables, carefully consider the computational burden of this model.
When there are a large number of explanatory variables, the data dimensionality reduction method can be used
to ensure the trade-off between analysis results and calculation speed.
}
\examples{
data('ndvi')
g = lesh(NDVIchange ~ ., data = ndvi)
g

}
\references{
Li, Y., Luo, P., Song, Y., Zhang, L., Qu, Y., & Hou, Z. (2023). A locally explained heterogeneity model for
examining wetland disparity. International Journal of Digital Earth, 16(2), 4533–4552.
https://doi.org/10.1080/17538947.2023.2271883
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
