% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolm_fit.R
\name{geolm_fit}
\alias{geolm_fit}
\title{Fit a \code{geolm}}
\usage{
geolm_fit(
  mod,
  x,
  y,
  coords,
  mu,
  weights,
  formula,
  coordnames,
  n,
  call,
  coeff_names
)
}
\arguments{
\item{mod}{A model object produced by one
of the \code{cmod_*} functions, e.g.,
\code{\link[gear]{cmod_std}}.}

\item{x}{The matrix of covariates.}

\item{y}{The vector of observed responses.}

\item{coords}{The coordinates of the observed data set.}

\item{mu}{A single numeric value indicating the consant
mean of the spatial process if simple kriging is
desired.  Default is \code{NULL}, meaning that ordinary
or universal kriging should be used.}

\item{weights}{A vector that is proportional to the reciprocal variances of the errors.}

\item{formula}{An object of class
\code{\link[stats]{formula}} providing a symbolic
description of the model to be fitted.  See Details of
this function and \code{\link[stats]{lm}}.}

\item{coordnames}{A vector of length 2 with the names of the columns in \code{data} containing the coordinates, e.g., \code{c("long", "lat")}.}

\item{n}{The number of observations.}

\item{call}{The \code{\link[base]{match.call}} for the \code{geolm}.}

\item{coeff_names}{A character string with the variable names associated with the coefficents.}
}
\value{
Returns a \code{geolm} with necessary
  components needed for \code{\link[gear]{estimate}} and
  \code{\link{predict}}.
}
\description{
\code{geolm_fit} fits a \code{geolm} based on the
specified \code{mod}. This is effectively an internal
function.
}
\examples{
# no examples since you shouldn't be using this function!
}
\author{
Joshua French
}
