% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gelnet.R
\name{gelnet.kor}
\alias{gelnet.kor}
\title{Kernel one-class regression}
\usage{
gelnet.kor(K, lambda, max.iter = 100, eps = 1e-05, v.init = rep(0,
  nrow(K)), silent = FALSE)
}
\arguments{
\item{K}{n-by-n matrix of pairwise kernel values over a set of n samples}

\item{lambda}{scalar, regularization parameter}

\item{max.iter}{maximum number of iterations}

\item{eps}{convergence precision}

\item{v.init}{initial parameter estimate for the kernel weights}

\item{silent}{set to TRUE to suppress run-time output to stdout (default: FALSE)}
}
\value{
A list with one element:
\describe{
  \item{v}{n-by-1 vector of kernel weights}
}
}
\description{
Learns a kernel one-class model for a given kernel matrix
}
\details{
The method operates by constructing iteratively re-weighted least squares approximations
of the log-likelihood loss function and then calling the kernel ridge regression routine
to solve those approximations. The least squares approximations are obtained via the Taylor series
expansion about the current parameter estimates.
}
\seealso{
\code{\link{gelnet.krr}}, \code{\link{gelnet.logreg}}
}

