% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countTokens.R
\name{countTokens}
\alias{countTokens}
\title{Count Tokens for Gemini Content (Including Images)}
\usage{
countTokens(
  jsonkey = NULL,
  model_id = NULL,
  content = NULL,
  region = "us-central1"
)
}
\arguments{
\item{jsonkey}{A path to JSON file containing the service account key from Vertex AI.}

\item{model_id}{The ID of the Gemini model.}

\item{content}{The content (text, image, or list of text/image parts) for which to count tokens.
\itemize{
\item For text, provide a string.
\item For images, provide a list with \code{data} (base64 encoded image) and \code{mimeType} (e.g., "image/png", "image/jpeg").
\item For multiple content parts, provide a list where each element is either a text string or an image list.
}}

\item{region}{The Google Cloud region where your Vertex AI resources are located (default is "us-central1").
See https://cloud.google.com/vertex-ai/docs/regions for available regions.}
}
\value{
A numeric value representing the token count of the content.
}
\description{
Calculates the token count for a given content, including text and image data, using the Vertex AI Gemini API.
}
\examples{
\dontrun{
library(gemini.R)

# For text content
key_file <- "YOURAPIKEY.json"
model <- "2.0-flash"
token_count_text <- countTokens(
  jsonkey = key_file, 
  model_id = model, 
  content = "Hello, world!"
)
print(token_count_text)

# For image content (assuming 'image.jpg' is in your working directory)
image_data <- base64enc::base64encode("image.jpg")
image_content <- list(data = image_data, mimeType = "image/jpeg")
token_count_image <- countTokens(
  jsonkey = key_file,
  model_id = model,
  content = image_content
)
print(token_count_image)

# For multiple content parts (text and image)
content_parts <- list(
  list(text = "This is the first part."),
  list(data = image_data, mimeType = "image/jpeg"),
  list(text = "This is the last part")
)
token_count_parts <- countTokens(
  jsonkey = key_file,
  model_id = model,
  content = content_parts
)
print(token_count_parts)
}

}
