/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.graph;

import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.drugis.mtc.graph.GraphUtil;

public class SpanningTreeIterable<V, E>
implements Iterable<Tree<V, E>> {
    private final DirectedGraph<V, E> d_graph;
    private final V d_root;
    private final Comparator<V> d_vertexComparator;

    public SpanningTreeIterable(DirectedGraph<V, E> graph, V root) {
        this(graph, root, null);
    }

    public SpanningTreeIterable(DirectedGraph<V, E> graph, V root, Comparator<V> vertexComparator) {
        this.d_graph = graph;
        this.d_root = root;
        this.d_vertexComparator = vertexComparator;
    }

    @Override
    public Iterator<Tree<V, E>> iterator() {
        return new SpanningTreeIterator();
    }

    public class SpanningTreeIterator
    implements Iterator<Tree<V, E>> {
        private Tree<V, E> d_last = null;
        private Tree<V, E> d_current = null;
        private LinkedList<ProblemState<V, E>> d_queue = new LinkedList();

        public SpanningTreeIterator() {
            DelegateTree initialTree = new DelegateTree();
            initialTree.setRoot(SpanningTreeIterable.this.d_root);
            this.d_queue.add(new ProblemState(SpanningTreeIterable.this.d_graph, initialTree, this.getOutEdges(SpanningTreeIterable.this.d_graph, SpanningTreeIterable.this.d_root), false));
        }

        @Override
        public boolean hasNext() {
            if (this.d_current == null) {
                this.d_current = this.findNext();
            }
            return this.d_current != null;
        }

        @Override
        public Tree<V, E> next() {
            if (this.hasNext()) {
                this.d_last = this.d_current;
                this.d_current = null;
                return this.d_last;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Tree<V, E> findNext() {
            while (!this.d_queue.isEmpty()) {
                ProblemState head = this.d_queue.pop();
                this.d_queue.addAll(0, this.successors(head));
                if (!this.isGoal(head)) continue;
                return head.tree;
            }
            return null;
        }

        private boolean isGoal(ProblemState<V, E> state) {
            return !state.widen && state.tree.getVertexCount() == SpanningTreeIterable.this.d_graph.getVertexCount();
        }

        private List<ProblemState<V, E>> successors(ProblemState<V, E> state) {
            if (state.fringe.isEmpty()) {
                return Collections.emptyList();
            }
            if (state.widen) {
                ProblemState succ = this.widenSucc(state);
                return succ == null ? Collections.emptyList() : Collections.singletonList(succ);
            }
            ArrayList list = new ArrayList();
            list.add(this.deepenSucc(state));
            list.add(new ProblemState(state.graph, state.tree, state.fringe, true));
            return list;
        }

        private ProblemState<V, E> widenSucc(ProblemState<V, E> state) {
            Object e = state.fringe.get(0);
            DirectedSparseGraph modGraph = new DirectedSparseGraph();
            GraphUtil.copyGraph(state.graph, modGraph);
            modGraph.removeEdge(e);
            if (this.bridgeTest(modGraph, state.graph.getDest(e))) {
                return null;
            }
            List newFringe = state.fringe.subList(1, state.fringe.size());
            return new ProblemState(modGraph, state.tree, newFringe, false);
        }

        private ProblemState<V, E> deepenSucc(ProblemState<V, E> state) {
            Object e = state.fringe.get(0);
            Object v = state.graph.getDest(e);
            DelegateTree newTree = new DelegateTree();
            GraphUtil.copyTree(state.tree, newTree);
            newTree.addChild(e, state.graph.getSource(e), v);
            ArrayList newFringe = new ArrayList();
            for (Object x : this.getOutEdges(state.graph, v)) {
                if (newTree.containsVertex(state.graph.getDest(x))) continue;
                newFringe.add(x);
            }
            for (Object x : state.fringe.subList(1, state.fringe.size())) {
                if (state.graph.getDest(x).equals(v)) continue;
                newFringe.add(x);
            }
            return new ProblemState(state.graph, newTree, newFringe, false);
        }

        private boolean bridgeTest(DirectedGraph<V, E> graph, V dest) {
            if (this.d_last == null) {
                throw new IllegalStateException();
            }
            for (Object e : graph.getInEdges(dest)) {
                if (GraphUtil.isDescendant(this.d_last, dest, graph.getSource(e))) continue;
                return false;
            }
            return true;
        }

        private List<E> getOutEdges(final DirectedGraph<V, E> graph, V v0) {
            ArrayList edges = new ArrayList(graph.getOutEdges(v0));
            if (SpanningTreeIterable.this.d_vertexComparator != null) {
                Collections.sort(edges, new Comparator<E>(){

                    @Override
                    public int compare(E e1, E e2) {
                        Object v1 = graph.getDest(e1);
                        Object v2 = graph.getDest(e2);
                        return SpanningTreeIterable.this.d_vertexComparator.compare(v1, v2);
                    }
                });
            }
            return edges;
        }
    }

    private static class ProblemState<V, E> {
        public final DirectedGraph<V, E> graph;
        public final Tree<V, E> tree;
        public final List<E> fringe;
        public final boolean widen;

        public ProblemState(DirectedGraph<V, E> graph, Tree<V, E> tree, List<E> fringe, boolean bridgeTest) {
            this.graph = graph;
            this.tree = tree;
            this.fringe = fringe;
            this.widen = bridgeTest;
        }
    }
}

