/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.ArgumentMaker;
import gov.lanl.yadas.ComponentIntegrator;
import gov.lanl.yadas.DataFrame;
import gov.lanl.yadas.NullIntegrator;
import gov.lanl.yadas.ParallelIntegrator;
import gov.lanl.yadas.SeriesIntegrator;
import java.util.ArrayList;

public class ReliableSystem {
    int size;
    ComponentIntegrator[] integrators;
    String[] componentNames;

    public ReliableSystem(int size) {
        this.size = size;
        this.integrators = new ComponentIntegrator[size];
        for (int i = 0; i < size; ++i) {
            this.integrators[i] = new NullIntegrator(i);
        }
    }

    public void addSubsystem(ComponentIntegrator integrator) {
        this.integrators[integrator.getSubsystem()] = integrator;
    }

    public void setNames(String[] names) {
        this.componentNames = names;
    }

    public int length() {
        return this.size;
    }

    public int getSize() {
        return this.size;
    }

    public ComponentIntegrator getIntegrator(int i) {
        return this.integrators[i];
    }

    public VJSystemProbArgument fillProbs(int[] expander, int[] order) {
        return new VJSystemProbArgument(expander, order);
    }

    public VJSystemProbArgument fillProbs(int[] expander) {
        return new VJSystemProbArgument(expander);
    }

    public DiagnosticSystemProbArgument diagnosticFillProbs(int[] expander, int[] order, ArgumentMaker biasarg) {
        return new DiagnosticSystemProbArgument(expander, order, biasarg);
    }

    public LogitAgeProbArgument logisticAgeProbs(DataFrame d, String variablename, int[] expander, int[] order, int[] nodes, int which0, int which1) {
        return new LogitAgeProbArgument(d, variablename, expander, order, nodes, which0, which1);
    }

    public LogitAgeProbArgument logisticAgeProbs(DataFrame d, String variablename, int[] expander, int[] nodes, int which0, int which1) {
        return new LogitAgeProbArgument(d, variablename, expander, nodes, which0, which1);
    }

    public LogitAgeProbArgumentPlus logisticAgeProbsPlus(DataFrame d, String variablename, int[] expander, int[] order, int[] nodes, int which0, int which1, int[] code, int jstar) {
        return new LogitAgeProbArgumentPlus(d, variablename, expander, order, nodes, which0, which1, code, jstar);
    }

    public LogitAgeProbArgumentPlus logisticAgeProbsPlus(DataFrame d, String variablename, int[] expander, int[] nodes, int which0, int which1, int[] code, int jstar) {
        return new LogitAgeProbArgumentPlus(d, variablename, expander, nodes, which0, which1, code, jstar);
    }

    public ArbitraryNodeProbArgument fillArbitraryProbs(ArgumentMaker[] argarray, int n, int[] expander, int[] order, int[] nodes) {
        return new ArbitraryNodeProbArgument(argarray, n, expander, order, nodes);
    }

    public ArbitraryNodeProbArgument fillArbitraryProbs(ArgumentMaker[] argarray, int n, int[] expander, int[] nodes) {
        return new ArbitraryNodeProbArgument(argarray, n, expander, nodes);
    }

    public ArbitraryNodeProbArgumentBNHack fillArbitraryProbsBayesNetHack(ArgumentMaker[] argarray, int n, int[] expander, int[] order, int[] nodes, double[] condprobs) {
        return new ArbitraryNodeProbArgumentBNHack(argarray, n, expander, order, nodes, condprobs);
    }

    public void SeriesIntegratorsFromFile(int[] parents) {
        int i;
        ArrayList[] al = new ArrayList[this.size];
        for (i = 0; i < this.size; ++i) {
            al[i] = new ArrayList();
        }
        for (i = 0; i < this.size; ++i) {
            if (parents[i] < 0) continue;
            al[parents[i]].add(new Integer(i));
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (al[i2].isEmpty()) continue;
            int[] children = new int[al[i2].size()];
            for (int j = 0; j < al[i2].size(); ++j) {
                children[j] = (Integer)al[i2].get(j);
            }
            this.addSubsystem(new SeriesIntegrator(children, i2));
        }
    }

    public void SPIntegratorsFromFile(int[] parents, int[] gate) {
        int i;
        ArrayList[] al = new ArrayList[this.size];
        for (i = 0; i < this.size; ++i) {
            al[i] = new ArrayList();
        }
        for (i = 0; i < this.size; ++i) {
            if (parents[i] < 0) continue;
            al[parents[i]].add(new Integer(i));
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (al[i2].isEmpty()) continue;
            int[] children = new int[al[i2].size()];
            for (int j = 0; j < al[i2].size(); ++j) {
                children[j] = (Integer)al[i2].get(j);
            }
            if (gate[i2] > 0) {
                this.addSubsystem(new SeriesIntegrator(children, i2));
                continue;
            }
            this.addSubsystem(new ParallelIntegrator(children, i2));
        }
    }

    public static void printrealvector(double[] vec) {
        String str = "";
        for (int i = 0; i < vec.length; ++i) {
            str = str + vec[i] + " ";
        }
        System.out.println(str);
    }

    public static void main(String[] args) {
        ReliableSystem testsys = new ReliableSystem(5);
        testsys.addSubsystem(new SeriesIntegrator(new int[]{3, 4}, 2));
        testsys.addSubsystem(new ParallelIntegrator(new int[]{1, 2}, 0));
        LogitAgeProbArgument arg = testsys.logisticAgeProbs(new DataFrame("h:/projects/stinger/fake/crap.dat"), "age", new int[]{-1, 0, -1, 1, 2}, new int[]{4, 3, 2, 1, 0}, new int[]{0, 1, 2, 3, 4, 0, 1, 2, 3, 4}, 0, 1);
        ReliableSystem.printrealvector(arg.getArgument(new double[][]{{-0.5, 0.0, 0.5}, {0.75, 0.0, 0.75}}));
    }

    public class ArbitraryNodeProbArgumentBNHack
    implements ArgumentMaker {
        ArgumentMaker[] argarray;
        int n;
        int[] vec;
        int[] expander;
        int[] order;
        int[] nodes;
        double[] condprobs;

        public ArbitraryNodeProbArgumentBNHack(ArgumentMaker[] argarray, int n, int[] expander, int[] order, int[] nodes, double[] condprobs) {
            this(argarray, n, expander, nodes, condprobs);
            this.order = order;
        }

        public ArbitraryNodeProbArgumentBNHack(ArgumentMaker[] argarray, int n, int[] expander, int[] nodes, double[] condprobs) {
            this.argarray = argarray;
            this.n = n;
            this.nodes = nodes;
            this.expander = expander;
            this.condprobs = condprobs;
            this.order = new int[ReliableSystem.this.size];
            for (int i = 0; i < ReliableSystem.this.size; ++i) {
                this.order[i] = i;
            }
            if (expander.length == ReliableSystem.this.size) {
                this.vec = expander;
            } else {
                this.build();
            }
        }

        public double[] getArgument(double[][] params) {
            double[] outp = new double[this.n];
            double[] midp = new double[ReliableSystem.this.size];
            double[][] argvalues = new double[this.argarray.length][];
            for (int h = 0; h < this.argarray.length; ++h) {
                argvalues[h] = this.argarray[h].getArgument(params);
            }
            int k = 0;
            while (k < this.n) {
                for (int i = 0; i < ReliableSystem.this.size; ++i) {
                    int j = this.order[i];
                    if (this.vec[j] > -1) {
                        midp[j] = argvalues[this.vec[j]][k];
                        continue;
                    }
                    if (j == 0) {
                        double[] cp = this.condprobs;
                        double p1 = midp[1];
                        double p2 = midp[2];
                        double p3 = midp[3];
                        midp[0] = cp[0] * p1 * p2 * p3 + cp[1] * (1.0 - p1) * p2 * p3 + cp[2] * p1 * (1.0 - p2) * p3 + cp[3] * p1 * p2 * (1.0 - p3) + cp[4] * (1.0 - p1) * (1.0 - p2) * p3 + cp[5] * p1 * (1.0 - p2) * (1.0 - p3) + cp[6] * (1.0 - p1) * p2 * (1.0 - p3) + cp[7] * (1.0 - p1) * (1.0 - p2) * (1.0 - p3);
                        continue;
                    }
                    midp[j] = ReliableSystem.this.integrators[j].combineProbabilities(new double[][]{midp});
                }
                int l = k++;
                outp[l] = midp[this.nodes[l]];
            }
            return outp;
        }

        public void build() {
            int i;
            this.vec = new int[ReliableSystem.this.size];
            for (i = 0; i < ReliableSystem.this.size; ++i) {
                this.vec[i] = -1;
            }
            for (i = 0; i < this.expander.length; ++i) {
                this.vec[this.expander[i]] = i;
            }
        }
    }

    public class ArbitraryNodeProbArgument
    implements ArgumentMaker {
        ArgumentMaker[] argarray;
        int n;
        int[] vec;
        int[] expander;
        int[] order;
        int[] nodes;

        public ArbitraryNodeProbArgument(ArgumentMaker[] argarray, int n, int[] expander, int[] order, int[] nodes) {
            this(argarray, n, expander, nodes);
            this.order = order;
        }

        public ArbitraryNodeProbArgument(ArgumentMaker[] argarray, int n, int[] expander, int[] nodes) {
            this.argarray = argarray;
            this.n = n;
            this.nodes = nodes;
            this.expander = expander;
            this.order = new int[ReliableSystem.this.size];
            for (int i = 0; i < ReliableSystem.this.size; ++i) {
                this.order[i] = i;
            }
            if (expander.length == ReliableSystem.this.size) {
                this.vec = expander;
            } else {
                this.build();
            }
        }

        public double[] getArgument(double[][] params) {
            double[] outp = new double[this.n];
            double[] midp = new double[ReliableSystem.this.size];
            double[][] argvalues = new double[this.argarray.length][];
            for (int h = 0; h < this.argarray.length; ++h) {
                argvalues[h] = this.argarray[h].getArgument(params);
            }
            int k = 0;
            while (k < this.n) {
                for (int i = 0; i < ReliableSystem.this.size; ++i) {
                    int j = this.order[i];
                    midp[j] = this.vec[j] > -1 ? argvalues[this.vec[j]][k] : ReliableSystem.this.integrators[j].combineProbabilities(new double[][]{midp});
                }
                int l = k++;
                outp[l] = midp[this.nodes[l]];
            }
            return outp;
        }

        public void build() {
            int i;
            this.vec = new int[ReliableSystem.this.size];
            for (i = 0; i < ReliableSystem.this.size; ++i) {
                this.vec[i] = -1;
            }
            for (i = 0; i < this.expander.length; ++i) {
                this.vec[this.expander[i]] = i;
            }
        }
    }

    public class LogitAgeProbArgumentPlus
    implements ArgumentMaker {
        int n;
        String variablename;
        int[] vec;
        int[] expander;
        int[] order;
        double[][] age;
        int[][] indexarr;
        int[] nodes;
        int which0;
        int which1;
        int[] code;
        int jstar;

        public LogitAgeProbArgumentPlus(DataFrame d, String variablename, int[] expander, int[] order, int[] nodes, int which0, int which1, int[] code, int jstar) {
            this(d, variablename, expander, nodes, which0, which1, code, jstar);
            this.order = order;
        }

        public LogitAgeProbArgumentPlus(DataFrame d, String variablename, int[] expander, int[] nodes, int which0, int which1, int[] code, int jstar) {
            int i;
            this.which0 = which0;
            this.which1 = which1;
            this.code = code;
            this.jstar = jstar;
            this.n = d.length();
            this.nodes = nodes;
            this.age = new double[ReliableSystem.this.size][this.n];
            for (i = 0; i < ReliableSystem.this.size; ++i) {
                this.age[i] = d.r(variablename + i);
            }
            this.expander = expander;
            this.order = new int[ReliableSystem.this.size];
            for (i = 0; i < ReliableSystem.this.size; ++i) {
                this.order[i] = i;
            }
            if (expander.length == ReliableSystem.this.size) {
                this.vec = expander;
            } else {
                this.build();
            }
        }

        public double[] getArgument(double[][] params) {
            double[] outp = new double[this.n];
            double[] midp = new double[ReliableSystem.this.size];
            for (int k = 0; k < this.n; ++k) {
                for (int i = 0; i < ReliableSystem.this.size; ++i) {
                    int j = this.order[i];
                    midp[j] = j == this.jstar && this.vec[j] > -1 ? 1.0 / (1.0 + Math.exp(params[0][this.vec[j]] + params[1][this.vec[j]] * this.age[this.vec[j]][k] * params[2][this.code[k]])) : (this.vec[j] > -1 ? 1.0 / (1.0 + Math.exp(params[0][this.vec[j]] + params[1][this.vec[j]] * this.age[this.vec[j]][k])) : ReliableSystem.this.integrators[j].combineProbabilities(new double[][]{midp}));
                }
                outp[k] = midp[this.nodes[k]];
            }
            return outp;
        }

        public void build() {
            int i;
            this.vec = new int[ReliableSystem.this.size];
            for (i = 0; i < ReliableSystem.this.size; ++i) {
                this.vec[i] = -1;
            }
            for (i = 0; i < this.expander.length; ++i) {
                this.vec[this.expander[i]] = i;
            }
        }
    }

    public class LogitAgeProbArgument
    implements ArgumentMaker {
        int n;
        String variablename;
        int[] vec;
        int[] expander;
        int[] order;
        double[][] age;
        int[][] indexarr;
        int[] nodes;
        int which0;
        int which1;

        public LogitAgeProbArgument(DataFrame d, String variablename, int[] expander, int[] order, int[] nodes, int which0, int which1) {
            this(d, variablename, expander, nodes, which0, which1);
            this.order = order;
        }

        public LogitAgeProbArgument(DataFrame d, String variablename, int[] expander, int[] nodes, int which0, int which1) {
            int i;
            this.which0 = which0;
            this.which1 = which1;
            this.n = d.length();
            this.nodes = nodes;
            this.age = new double[ReliableSystem.this.size][this.n];
            for (i = 0; i < ReliableSystem.this.size; ++i) {
                this.age[i] = d.r(variablename + i);
            }
            this.expander = expander;
            this.order = new int[ReliableSystem.this.size];
            for (i = 0; i < ReliableSystem.this.size; ++i) {
                this.order[i] = i;
            }
            if (expander.length == ReliableSystem.this.size) {
                this.vec = expander;
            } else {
                this.build();
            }
        }

        public double[] getArgument(double[][] params) {
            double[] outp = new double[this.n];
            double[] midp = new double[ReliableSystem.this.size];
            int k = 0;
            while (k < this.n) {
                for (int i = 0; i < ReliableSystem.this.size; ++i) {
                    int j = this.order[i];
                    midp[j] = this.vec[j] > -1 ? 1.0 / (1.0 + Math.exp(params[0][this.vec[j]] + params[1][this.vec[j]] * this.age[this.vec[j]][k])) : ReliableSystem.this.integrators[j].combineProbabilities(new double[][]{midp});
                }
                int l = k++;
                outp[l] = midp[this.nodes[l]];
            }
            return outp;
        }

        public void build() {
            int i;
            this.vec = new int[ReliableSystem.this.size];
            for (i = 0; i < ReliableSystem.this.size; ++i) {
                this.vec[i] = -1;
            }
            for (i = 0; i < this.expander.length; ++i) {
                this.vec[this.expander[i]] = i;
            }
        }
    }

    public class VJSystemProbArgument
    implements ArgumentMaker {
        int[] vec;
        int[] expander;
        int[] order;

        public VJSystemProbArgument(int[] expander, int[] order) {
            this.expander = expander;
            this.order = order;
            if (expander.length == ReliableSystem.this.size) {
                this.vec = expander;
            } else {
                this.build();
            }
        }

        public VJSystemProbArgument(int[] expander) {
            this.expander = expander;
            this.order = new int[ReliableSystem.this.size];
            for (int i = 0; i < ReliableSystem.this.size; ++i) {
                this.order[i] = i;
            }
            System.out.println("Using default order to compute subsystem probabilities.");
            if (expander.length == ReliableSystem.this.size) {
                this.vec = expander;
            } else {
                this.build();
            }
        }

        public double[] getArgument(double[][] params) {
            double[] outp = new double[ReliableSystem.this.size];
            for (int i = 0; i < ReliableSystem.this.size; ++i) {
                int j = this.order[i];
                outp[j] = this.vec[j] > -1 ? params[0][this.vec[j]] : ReliableSystem.this.integrators[j].combineProbabilities(new double[][]{outp});
            }
            return outp;
        }

        public void build() {
            int i;
            this.vec = new int[ReliableSystem.this.size];
            for (i = 0; i < ReliableSystem.this.size; ++i) {
                this.vec[i] = -1;
            }
            for (i = 0; i < this.expander.length; ++i) {
                this.vec[this.expander[i]] = i;
            }
        }
    }

    public class DiagnosticSystemProbArgument
    implements ArgumentMaker {
        int[] vec;
        int[] expander;
        int[] order;
        ArgumentMaker biasarg;

        public DiagnosticSystemProbArgument(int[] expander, int[] order, ArgumentMaker biasarg) {
            this.expander = expander;
            this.order = order;
            if (expander.length == ReliableSystem.this.size) {
                this.vec = expander;
            } else {
                this.build();
            }
            this.biasarg = biasarg;
        }

        public DiagnosticSystemProbArgument(int[] expander, ArgumentMaker biasarg) {
            this.expander = expander;
            this.order = new int[ReliableSystem.this.size];
            for (int i = 0; i < ReliableSystem.this.size; ++i) {
                this.order[i] = i;
            }
            System.out.println("Using default order to compute subsystem probabilities.");
            if (expander.length == ReliableSystem.this.size) {
                this.vec = expander;
            } else {
                this.build();
            }
            this.biasarg = biasarg;
        }

        public double[] getArgument(double[][] params) {
            double[] barg = this.biasarg.getArgument(params);
            double[] outp = new double[ReliableSystem.this.size];
            for (int i = 0; i < ReliableSystem.this.size; ++i) {
                int j = this.order[i];
                if (this.vec[j] > -1) {
                    outp[j] = params[0][this.vec[j]];
                    continue;
                }
                double tempop = ReliableSystem.this.integrators[j].combineProbabilities(new double[][]{outp});
                outp[j] = tempop / (tempop + (1.0 - tempop) * Math.exp(-barg[j]));
            }
            return outp;
        }

        public void build() {
            int i;
            this.vec = new int[ReliableSystem.this.size];
            for (i = 0; i < ReliableSystem.this.size; ++i) {
                this.vec[i] = -1;
            }
            for (i = 0; i < this.expander.length; ++i) {
                this.vec[this.expander[i]] = i;
            }
        }
    }
}

