/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.metrics;

import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metrics {
    public static <V, E> Map<V, Double> clusteringCoefficients(Graph<V, E> graph) {
        HashMap coefficients = new HashMap();
        for (Object v : graph.getVertices()) {
            int n = graph.getNeighborCount(v);
            if (n < 2) {
                coefficients.put(v, new Double(0.0));
                continue;
            }
            ArrayList neighbors = new ArrayList(graph.getNeighbors(v));
            double edge_count = 0.0;
            for (int i = 0; i < n; ++i) {
                Object w = neighbors.get(i);
                for (int j = i + 1; j < n; ++j) {
                    Object x = neighbors.get(j);
                    edge_count += graph.isNeighbor(w, x) ? 1.0 : 0.0;
                }
            }
            double possible_edges = (double)(n * (n - 1)) / 2.0;
            coefficients.put(v, new Double(edge_count / possible_edges));
        }
        return coefficients;
    }
}

