/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.ArgumentMaker;
import gov.lanl.yadas.BasicMCMCBond;
import gov.lanl.yadas.ConstantArgument;
import gov.lanl.yadas.DataFrame;
import gov.lanl.yadas.Gamma;
import gov.lanl.yadas.Gaussian;
import gov.lanl.yadas.GroupArgument;
import gov.lanl.yadas.IdentityArgument;
import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.MCMCUpdate;
import gov.lanl.yadas.ScalarFrame;
import java.util.ArrayList;

public class OneWayAnova {
    public static void main(String[] args) {
        int i;
        MCMCParameter delta;
        MCMCParameter sigma;
        MCMCParameter theta;
        int B = 1000;
        String direc = "";
        String filename = "Ex1data.dat";
        String filename2 = "Ex1mu.dat";
        String shortfilename = "Ex1scalars.dat";
        try {
            if (args.length > 0) {
                B = Integer.parseInt(args[0]);
            }
            if (args.length > 1) {
                direc = args[1];
            }
            if (args.length > 2) {
                filename = args[2];
            }
            if (args.length > 3) {
                filename2 = args[3];
            }
            if (args.length > 4) {
                shortfilename = args[4];
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Poor argument list!" + e);
        }
        DataFrame d = new DataFrame(direc + filename);
        DataFrame d2 = new DataFrame(direc + filename2);
        ScalarFrame d0 = new ScalarFrame(direc + shortfilename);
        MCMCParameter mu = new MCMCParameter(d2.r("mu"), d2.r("mumss"), direc + "mu");
        MCMCParameter[] paramarray = new MCMCParameter[]{mu, theta = new MCMCParameter(d0.r("theta"), d0.r("thetamss"), direc + "theta"), sigma = new MCMCParameter(d0.r("sigma"), d0.r("sigmamss"), direc + "sigma"), delta = new MCMCParameter(d0.r("delta"), d0.r("deltamss"), direc + "delta")};
        ArrayList<BasicMCMCBond> bondlist = new ArrayList<BasicMCMCBond>();
        BasicMCMCBond databond = new BasicMCMCBond(new MCMCParameter[]{mu, sigma}, new ArgumentMaker[]{new ConstantArgument(d.r("y")), new GroupArgument(0, d.i("group")), new GroupArgument(1, d.i(0))}, new Gaussian());
        bondlist.add(databond);
        BasicMCMCBond muprior = new BasicMCMCBond(new MCMCParameter[]{mu, theta, delta}, new ArgumentMaker[]{new IdentityArgument(0), new GroupArgument(1, d2.i(0)), new GroupArgument(2, d2.i(0))}, new Gaussian());
        bondlist.add(muprior);
        BasicMCMCBond sigmaprior = new BasicMCMCBond(new MCMCParameter[]{sigma}, new ArgumentMaker[]{new IdentityArgument(0), new ConstantArgument(d0.r("asigma")), new ConstantArgument(d0.r("bsigma"))}, new Gamma());
        bondlist.add(sigmaprior);
        BasicMCMCBond deltaprior = new BasicMCMCBond(new MCMCParameter[]{delta}, new ArgumentMaker[]{new IdentityArgument(0), new ConstantArgument(d0.r("adelta")), new ConstantArgument(d0.r("bdelta"))}, new Gamma());
        bondlist.add(deltaprior);
        MCMCUpdate[] updatearray = new MCMCUpdate[]{mu, theta, sigma, delta};
        for (int b = 0; b < B; ++b) {
            if ((double)b / 1000.0 - (double)(b / 1000) == 0.0) {
                System.out.println(b);
            }
            for (i = 0; i < updatearray.length; ++i) {
                updatearray[i].update();
            }
            for (i = 0; i < paramarray.length; ++i) {
                paramarray[i].output();
            }
        }
        for (int iii = 0; iii < updatearray.length; ++iii) {
            String acc = updatearray[iii].accepted();
            System.out.println("Update " + iii + ": " + acc);
        }
        for (i = 0; i < paramarray.length; ++i) {
            paramarray[i].finish();
        }
    }
}

