/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading;

import org.drugis.common.threading.ExtendableIterativeComputation;
import org.drugis.common.threading.IterativeComputation;
import org.drugis.common.threading.IterativeSuspendable;
import org.drugis.common.threading.IterativeTask;

public class ExtendableIterativeTask
extends IterativeTask {
    private final String d_str;
    private final ExtendableIterativeComputation d_computation;

    public ExtendableIterativeTask(IterativeComputation computation, String str) {
        super(computation, str);
        if (!(computation instanceof ExtendableIterativeComputation)) {
            throw new IllegalArgumentException("Computation not an instanceof IterativeExtendableComputation");
        }
        this.d_computation = (ExtendableIterativeComputation)computation;
        this.d_str = str;
        ((IterativeSuspendable)this.d_suspendable).setListenerManager(this.d_mgr);
    }

    public ExtendableIterativeTask(IterativeComputation computation) {
        this(computation, computation.toString());
    }

    public void extend(int iterations) {
        this.d_finished = false;
        this.d_started = false;
        int oldIterations = this.d_computation.getTotalIterations();
        this.d_computation.setTotalIterations(oldIterations + iterations);
        this.d_mgr.fireTaskRestarted();
    }

    public String toString() {
        return this.d_str;
    }
}

