/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading.activity;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drugis.common.threading.Task;
import org.drugis.common.threading.activity.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityModel {
    private final Task d_start;
    private final Task d_end;
    private Map<Task, Transition> d_transitions = new HashMap<Task, Transition>();

    public ActivityModel(Task start, Task end, Collection<? extends Transition> transitions) {
        this.d_start = start;
        this.d_end = end;
        for (Transition transition : transitions) {
            for (Task s : transition.getSources()) {
                this.d_transitions.put(s, transition);
            }
        }
    }

    public Set<Task> getNextStates() {
        if (this.isFinished()) {
            return Collections.emptySet();
        }
        return this.findAccessibleStates(this.d_start);
    }

    private Set<Task> findAccessibleStates(Task state) {
        if (!state.isFinished()) {
            return Collections.singleton(state);
        }
        Transition trans = this.d_transitions.get(state);
        if (!trans.isReady()) {
            return Collections.emptySet();
        }
        HashSet<Task> accessible = new HashSet<Task>();
        List<Task> next = trans.transition();
        for (Task task : next) {
            accessible.addAll(this.findAccessibleStates(task));
        }
        return accessible;
    }

    public boolean isFinished() {
        return this.d_end.isFinished();
    }

    public Task getStartState() {
        return this.d_start;
    }

    public Task getEndState() {
        return this.d_end;
    }

    public Set<Task> getStates() {
        HashSet<Task> tasks = new HashSet<Task>(this.d_transitions.keySet());
        tasks.add(this.d_end);
        return tasks;
    }

    public Task getStateByName(String name) {
        for (Task t : this.getStates()) {
            if (!name.equals(t.toString())) continue;
            return t;
        }
        return null;
    }

    public Set<Transition> getTransitions() {
        return new HashSet<Transition>(this.d_transitions.values());
    }
}

