% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_handling.R
\name{create_input_config}
\alias{create_input_config}
\title{creates either an empty configuration or a pre-filled configuration object from a config file.}
\usage{
create_input_config(config_file = NA)
}
\arguments{
\item{config_file}{the path to a valid configuration file. if NA it creates an empty config.}
}
\value{
list of configuration elements, similar generated from reading a config_file.R. The internal elements of this list are: "general", "initialization", "dispersal", "speciation", "mutation" and "ecology".
}
\description{
creates either an empty configuration or a pre-filled configuration object from a config file.
}
\examples{
# create empty config object
config_empty <- create_input_config(config_file = NA)

# create a config object from config_file
# get path to example config
datapath <- system.file(file.path("extdata", "WorldCenter"), package = "gen3sis")
path_config <- file.path(datapath, "config/config_worldcenter.R")
config_object <- create_input_config(config_file = path_config)

# change seed of config_worldcenter config object
config_object$gen3sis$general$random_seed <- 2020

# run the model for config_object
\donttest{
  sim <- run_simulation(config = config_object, 
                        landscape = file.path(datapath, "landscape"), 
                        output_directory = tempdir())
}
}
