% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{generateKirchenplotBCdis}
\alias{generateKirchenplotBCdis}
\title{Plotting a Kirchenplot}
\usage{
generateKirchenplotBCdis(BC_dat, ori_BCs = NULL, loga = TRUE,
  col_type = NULL)
}
\arguments{
\item{BC_dat}{a BCdat object.}

\item{ori_BCs}{a vector of character strings containing the initial barcode sequences.}

\item{loga}{a logical value, indicating the use or non-use of logarithmic read count values.}

\item{col_type}{character sting, choosing one of the availabe color palettes, e.g. rainbow}
}
\value{
a ggplot2 object
}
\description{
Generates a barplot based on read counts. If \code{ori_BCs} is provided the bar color reflects the hamming
distance of a particular barcode to one of the provided initial barcode sequences.
}
\examples{
data(BC_dat)
generateKirchenplotBCdis(BC_dat, ori_BCs, loga = TRUE, col_type = NULL)
}
