% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plotClusterTree}
\alias{plotClusterTree}
\title{Plotting a Cluster Tree}
\usage{
plotClusterTree(BC_dat, tree_est = c("NJ", "UPGMA"), type = c("unrooted",
  "phylogram", "cladogram", "fan", "radial"), tipLabel = FALSE)
}
\arguments{
\item{BC_dat}{a BCdat object.}

\item{tree_est}{a character string, indicating the particular cluster algorithm, possible algorithms are "Neighbor-Joining" ("NJ") and "Unweighted Pair Group Method" ("UPGMA").}

\item{type}{a character string, indication the graph layout style.}

\item{tipLabel}{a logical value, indication the use of labeled tree leaves.}
}
\value{
a ggtree object.
}
\description{
Generates a tree plot based on a herachical clustering of the complete hamming distance matrix.
}
\examples{
data(BC_dat)
plotClusterTree(BC_dat, tree_est = "UPGMA", type = "unrooted", tipLabel = FALSE)
}
