% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{generateKirchenplot}
\alias{generateKirchenplot}
\title{Plotting a Kirchenplot}
\usage{
generateKirchenplot(BC_dat, ori_BCs = NULL, ori_BCs2 = NULL, loga = TRUE,
  col_type = NULL, m = "hamming", setLabels = c("BC-Set 1", "Rest",
  "BC-Set 2"))
}
\arguments{
\item{BC_dat}{a BCdat object.}

\item{ori_BCs}{a vector of character strings containing known barcode sequences (without the fixed positions of the barcode construct).}

\item{ori_BCs2}{a vector of character strings containing a 2nd set of known barcode sequences (also without the fixed positions).}

\item{loga}{a logical value, indicating the use or non-use of logarithmic read count values.}

\item{col_type}{character sting, choosing one of the availabe color palettes, e.g. rainbow.}

\item{m}{a character string, Method for distance calculation, default value is Hamming distance. Possible values
are "osa", "lv", "dl", "hamming", "lcs", "qgram", "cosine", "jaccard", "jw", "soundex" (see stringdist function
of the stringdist-package for more information).}

\item{setLabels}{a character vector, containing three strings serving as plot labels.}
}
\value{
a ggplot2 object
}
\description{
Generates a barplot based on read counts. If \code{ori_BCs} is provided the bar color reflects the
distance between a particular barcode to one of the provided barcode sequences.
}
\examples{
data(BC_dat)
generateKirchenplot(BC_dat, ori_BCs, loga = TRUE, col_type = NULL)
}
