% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plotDistanceIgraph}
\alias{plotDistanceIgraph}
\title{Plotting a Distance Network}
\usage{
plotDistanceIgraph(BC_dat, minDist = 1, loga = TRUE, ori_BCs = NULL,
  threeD = FALSE, complete = FALSE, col_type = "rainbow",
  leg_pos = "left", inset = -0.125, title = "Distance", m = "hamming")
}
\arguments{
\item{BC_dat}{a BCdat object.}

\item{minDist}{an integer value representing the maximal distance value for which the graph will
contain edges.}

\item{loga}{a logical value, indicating the use or non-use of logarithmic read count values.}

\item{ori_BCs}{a vector of character strings containing the barcode sequences (without the fixed positions of the barcode construct).}

\item{threeD}{a logical value to chose between 2D and 3D visualisation.}

\item{complete}{a logical value. If TRUE, every node will have at least one edge.}

\item{col_type}{a character sting, choosing one of the available color palettes.}

\item{leg_pos}{a character string, containing the position of the legend (e.g. topleft), if NULL no legend will be plotted}

\item{inset}{a numeric value, specifying the distance from the margins as a fraction of the plot region}

\item{title}{a character string, containing the legend title}

\item{m}{a character string, Method for distance calculation, default value is Hamming distance. Possible values
are "osa", "lv", "dl", "hamming", "lcs", "qgram", "cosine", "jaccard", "jw", "soundex" (see stringdist function
of the stringdist-package for more information).}
}
\value{
an igraph object.
}
\description{
plotDistanceIgraph will create a graph-like visualisation (ripple plot) of the corresponding barcode sequences
and their similarity based on the igraph package. The nodes represent the barcode sequences and their
respective size reflects the corresponding read counts. Edges between nodes indicate a distance between two barcodes
of maximal \code{minD}.
If \code{ori_BCs} is provided the node color also refelects the distance of a particular barcode to one of the initial
barcodes.
}
\examples{
data(BC_dat)
plotDistanceIgraph(BC_dat, minDist = 1, loga = TRUE, ori_BCs, threeD = FALSE,
complete = FALSE, col_type = "rainbow")
}
