% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genderizeAPI.R
\name{genderizeAPI}
\alias{genderizeAPI}
\title{Getting data from genderize.io  API}
\usage{
genderizeAPI(x, apikey = NULL, ssl.verifypeer = TRUE)
}
\arguments{
\item{x}{A vector of terms to check in genderize.io database.}

\item{apikey}{A character string with the API key obtained via https://store.genderize.io. A default is NULL, which uses the free API plan.}

\item{ssl.verifypeer}{Checks the SSL Certificate. Default is TRUE.}
}
\value{
A list of four elements: \code{response} is a data frame with names, genders, probabilities and counts or \code{NULL} if non of the terms are not located in the genderize.io database; \code{limitLeft} is showing how many queries to the API are still possible within the current \code{limit} which will be renewed in \code{limitReset} seconds.
}
\description{
\code{genderizeAPI} connects with genderize.io API and checks if 
a term (one or more) is in the given names database and returns 
its gender probability and count of the cases recorded in the database.
}
\examples{
\dontrun{

terms = c("loremipsum")
genderizeAPI(terms)$response
# Null data.table (0 rows and 0 cols)

terms = c("jan", "maria", "norbert", "winston", "loremipsum")
genderizeAPI(terms)
 
# example of the function output 
$response
      name gender probability count
      1:     jan   male        0.60  1692
      2:   maria female        0.99  8467
      3: norbert   male        1.00    77
      4: winston   male        0.98   128

$limitLeft
[1] 967

$limit
[1] 1000

$limitReset
[1] 83234 

}

}

