% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcf2hap.R
\name{vcf2hap}
\alias{vcf2hap}
\title{Generat Haps from VCF}
\usage{
vcf2hap(vcf,
        hapPrefix = "H",
        filter_Chr = FALSE,
        Chr = Chr,
        filter_POS = FALSE,
        startPOS = startPOS,
        endPOS = endPOS,
        hyb_remove = TRUE,
        na.drop = TRUE)
}
\arguments{
\item{vcf}{vcfR object imported by \code{import_vcf()}}

\item{hapPrefix}{prefix of hap names, default as "H"}

\item{filter_Chr}{logical, whether filter vcf by chromosome or not. Default
as \code{FALSE}. If set as \code{TRUE}, \code{Chr} is needed}

\item{Chr}{Chromosome name, needed when \code{filter_Chr} was set as \code{TRUE}}

\item{filter_POS}{logical, whether filter vcf by position or not. Default
as \code{FALSE}. If set as \code{TRUE}, \code{startPOS} and \code{endPOS} are needed}

\item{startPOS, endPOS}{start and end position, needed when \code{filter_POS} was
set as \code{TRUE}. In addition, \code{startPOS} must less than \code{endPOS}}

\item{hyb_remove}{whether remove accessions contains hybrid site or not.
Default as \code{TRUE}}

\item{na.drop}{whether remove accessions contains unknown allele site or not
Default as \code{TRUE}.}
}
\value{
object of hapResult class
}
\description{
Generate hapResult from vcfR object
A simple filter by position was provided in this function,
however it's prefer to filter VCF (vcfR object) through
\code{\link[geneHapR:filter_vcf]{filter_vcf()}}.
}
\examples{
data("geneHapR_test")
hapResult <- vcf2hap(vcf)
}
\seealso{
extract genotype from vcf:
\code{\link[vcfR:extract_gt_tidy]{vcfR::extract_gt_tidy()}},
import vcf files:
\code{\link[geneHapR:import_vcf]{import_vcf()}} (preferred) and
\code{\link[vcfR:read.vcfR]{vcfR::read.vcfR()}},
filter vcf according \strong{position} and \strong{annotations}:
\code{\link[geneHapR:filter_vcf]{filter_vcf()}}
}
\author{
Zhangrenl
}
