% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genGSEA.R
\name{genGSEA}
\alias{genGSEA}
\title{Gene Set Enrichment Analysis (FCS method)}
\usage{
genGSEA(
  genelist,
  geneset,
  padj_method = "BH",
  p_cutoff = 0.05,
  q_cutoff = 0.05,
  min_gset_size = 10,
  max_gset_size = 500,
  set_seed = FALSE
)
}
\arguments{
\item{genelist}{Order ranked genelist in decreasing order, gene can be
entrez, ensembl or symbol.}

\item{geneset}{Gene set is a two-column data.frame with term id and gene id.
Please use package `geneset` to select available gene set or make new one.}

\item{padj_method}{One of "BH", "BY", "bonferroni","fdr","hochberg",
"holm", "hommel", "none"}

\item{p_cutoff}{Numeric of cutoff for both unadjusted and adjusted pvalue, default is 0.05.}

\item{q_cutoff}{Numeric of cutoff for qvalue, default is 0.05.}

\item{min_gset_size}{Numeric of minimal size of each geneset for analyzing,
default is 10.}

\item{max_gset_size}{Numeric of maximal size of each geneset for analyzing,
default is 500.}

\item{set_seed}{GSEA permutations are performed using random reordering,
which causes slightly difference results after every time running.
If user want to get same result every time for same input,
please set `set_seed = TRUE` or `set.seed()` prior to running.}
}
\value{
A `data.frame`.
}
\description{
Gene Set Enrichment Analysis (FCS method)
}
\examples{
\dontrun{
# only gene ids
data(geneList, package = "genekitr")
gs <- geneset::getGO(org = "human",ont = "mf")
gse <- genGSEA(genelist = geneList, geneset = gs)

}
}
