% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genepop.R
\name{IBD}
\alias{IBD}
\alias{ibd}
\title{Isolation by distance}
\usage{
ibd(
  inputFile,
  outputFile = "",
  settingsFile = "",
  dataType = "Diploid",
  statistic = "F/(1-F)",
  geographicScale = "2D",
  CIcoverage = 0.95,
  testPoint = 0,
  minimalDistance = 1e-04,
  maximalDistance = 1e+09,
  mantelPermutations = 1000,
  mantelRankTest = FALSE,
  verbose = interactive()
)
}
\arguments{
\item{inputFile}{The path of the input file, in Genepop format}

\item{outputFile}{character: The path of the output file}

\item{settingsFile}{character: The path of the settings file}

\item{dataType}{character: \code{'haploid'} or \code{'diploid'}}

\item{statistic}{character: The pairwise genetic distance, either \code{'a'} or \code{'e'} for diploid individual data, \code{'a-like'} for haploid individual data, and \code{'F/(1-F)'} or \code{'SingleGeneDiv'} for group data (haploid or diploid)}

\item{geographicScale}{character: gives either the scale transformation \code{'Log'} or \code{'Linear'}  for geographic distances, or the shape of the habitat \code{'2D'} or \code{'1D'}}

\item{CIcoverage}{numeric: The coverage probability of confidence intervals}

\item{testPoint}{numeric: Given value of the slope to be tested}

\item{minimalDistance}{numeric: The minimal geographic distance}

\item{maximalDistance}{numeric: The maximal geographic distance}

\item{mantelPermutations}{numeric: The number of permutations may be specified}

\item{mantelRankTest}{logical: whether to use ranks in the Mantel test}

\item{verbose}{logical: whether to print some information}
}
\value{
The path of the output file is returned invisibly.
}
\description{
Estimates isolation by distance by regression of genetic distance to geographical distance. See \href{../doc/all-menu-options.html#sub-option-5-isolation-by-distance-between-individuals}{this section} of the Genepop executable documentation for more information on individual-based analyses and \href{../doc/all-menu-options.html#sub-option-6-isolation-by-distance-between-groups}{this one} for group-based analyses.
}
\examples{
\dontrun{
locinfile <- genepopExample('w2.txt')
outfile <- ibd(locinfile,'w2.txt.ISO', geographicScale = 'Log', statistic='e')
if ( ! interactive()) clean_workdir(otherfiles='w2.txt')

locinfile <- genepopExample('PEL1600withCoord.txt')
outfile <- ibd(locinfile,'PEL1600withCoord.ISO', statistic = 'SingleGeneDiv',
               geographicScale = '1D')
if ( ! interactive()) clean_workdir(otherfiles='PEL1600withCoord.txt')
}
}
