% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/somePairs2.R
\name{somePairs2}
\alias{somePairs2}
\title{Function reporting kernel causality results as a 7-column matrix, version 2.}
\usage{
somePairs2(mtx, dig = 6, verbo = FALSE, typ = 1, rnam = FALSE)
}
\arguments{
\item{mtx}{{The data matrix in the first column is paired with all others.}}

\item{dig}{{Number of digits for reporting (default \code{dig}=6).}}

\item{verbo}{{Make \code{verbo= TRUE} for printing detailed steps.}}

\item{typ}{{Must be 1 (default), 2 or 3 for the three criteria.}}

\item{rnam}{{Make \code{rnam= TRUE} if cleverly created rownames are desired.}}
}
\value{
A matrix containing causal identification results for one criterion.
The first column of the input \code{mtx} having p columns
is paired with (p-1) other columns  The output matrix headings are
self-explanatory and distinct for each criterion Cr1 to Cr3.
}
\description{
This function is an alternative implementation of \code{somePairs}
which also lets the user choose one of three criteria to determine causal direction
by setting \code{typ} as 1, 2 or 3.  This function reports results for 
only one criterion at a time unlike the function \code{some0Pairs} which
summarizes the resulting causal directions for all criteria with suitable weights.
If some variables are `control' variables, use \code{someCPairs}, 
where notation C=control.
}
\details{
(typ=1) reports ('Y', 'X', 'Cause',
'SD1.rhserr', 'SD2.rhserr', 'SD3.rhserr', 'SD4.rhserr') 
naming variables identifying the 'cause'
and measures of stochastic dominance using absolute values of kernel
regression abs(RHS first regressor*residual) 
comparing flipped regressions X on Y versus Y on X.

{(typ=2)} 
 reports ('Y', 'X', 'Cause', 'SD1res', 'SD2res', 'SD3res', 'SD4res')
 and measures of stochastic dominance using absolute values of kernel
 regression residuals comparing regression of X on Y with that of Y on X.

{(typ=3)} 
reports ('Y', 'X', 'Cause', 'r*X|Y', 'r*Y|X', 'r', 'p-val')
containing generalized correlation coefficients r*, 'r' refers to the
Pearson correlation coefficient and p-val column has the p-values for 
testing the significance of Pearson's 'r'.
}
\examples{

\dontrun{
data(mtcars)
somePairs2(mtcars)
}

}
\references{
H. D. Vinod 'Generalized Correlation and Kernel Causality with
 Applications in Development Economics' in Communications in
 Statistics -Simulation and Computation, 2015,
 \url{http://dx.doi.org/10.1080/03610918.2015.1122048}
}
\seealso{
The related function \code{\link{some0Pairs}} may be more useful, since it
reports on all three criteria (by choosing typ=1,2,3) and
further summarizes their results by weighting to help choose causal paths.

Alternative and revised function \code{\link{somePairs2}} 
implements the Cr1 (first criterion) with a direct estimate of
the Hausman-Wu statistic for testing exogeneity.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\keyword{SD1,}
\keyword{SD2,}
\keyword{SD3,}
\keyword{SD4,}
\keyword{causal}
\keyword{correlations}
\keyword{criteria,}
\keyword{generalized}
