% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_tooltip}
\alias{GC_tooltip}
\title{Set Tooltip for a Gene Chart}
\usage{
GC_tooltip(
  GC_chart,
  formatter = "<b>Start:</b> {start}<br><b>End:</b> {end}",
  show = TRUE,
  cluster = NULL,
  ...
)
}
\arguments{
\item{GC_chart}{The gene chart object to be modified.}

\item{formatter}{A character string defining the HTML content of the tooltip. It can
include placeholders like \code{\{start\}} and \code{\{end\}} which will be replaced by actual
data values. The default value shows start and end data.}

\item{show}{Logical, whether to display the tooltip or not.}

\item{cluster}{Optional; used to specify which clusters in the chart should have tooltips.}

\item{...}{Additional arguments that can be used to further customize the tooltip.}
}
\value{
Returns the gene chart object with the tooltip configured.
}
\description{
This function configures the tooltip for a gene chart.
}
\examples{
# Set tooltip
genes_data <- data.frame(
  start = c(10, 90, 130, 170, 210),
  end = c(40, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 2', 'Gene 3', 'Gene 4', 'Gene 5'),
  group = c('A', 'B', 'B', 'A', 'C')
)

# Add tooltips to the gene chart
GC_chart(genes_data, group = "group", height = "200px") \%>\%
GC_tooltip(formatter = " <b>Start:</b> {start}<br><b>end:</b> {end}")

}
