% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sex_to_char.R
\name{sex_to_char}
\alias{sex_to_char}
\title{Convert integer sex codes to character codes}
\usage{
sex_to_char(sex)
}
\arguments{
\item{sex}{Integer vector of sex codes}
}
\value{
The converted character vector of sex codes
}
\description{
This function accepts the integer sex codes accepted by Plink and turns them into the character codes accepted by Eigenstrat.
Only upper-case characters are returned.
Cases outside the table below are mapped to \code{U} (unknown) with a warning.
The correspondence is:
\itemize{
\item \code{0}: \code{U} (unknown)
\item \code{1}: \code{M} (male)
\item \code{2}: \code{F} (female)
}
}
\examples{
# verify the mapping above
sex_int <- 0:2
sex_char <- c('U', 'M', 'F') # expected values
stopifnot(
  all(
    sex_to_char( sex_int ) == sex_char
  )
)

}
\seealso{
\code{\link[=sex_to_int]{sex_to_int()}}

Eigenstrat IND format reference:
\url{https://github.com/DReichLab/EIG/tree/master/CONVERTF}

Plink FAM format reference:
\url{https://www.cog-genomics.org/plink/1.9/formats#fam}
}
