% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artists.R
\name{get_artist_songs_df}
\alias{get_artist_songs_df}
\title{Retrieve metadata for all of an artist's songs}
\usage{
get_artist_songs_df(
  artist_id,
  sort = c("title", "popularity"),
  include_features = FALSE,
  access_token = genius_token()
)
}
\arguments{
\item{artist_id}{ID of the artist (\code{artist_id} within an object returned by
\code{\link{search_artist}})}

\item{sort}{method to order results; by "title" (default) or by
"popularity"}

\item{include_features}{Whether to return results where artist
isn't the primary artist (logical, defaults to FALSE)}

\item{access_token}{Genius' client access token, defaults to \code{genius_token}}
}
\value{
a tibble
}
\description{
The Genius API lets you search for song metadata of an artist,
given an artist ID. \code{get_artist_songs_df} returns this data
in a tidy, but reduced, format.
}
\examples{
\dontrun{
get_artist_songs_df(artist_id = 1421)
}
}
\seealso{
See \code{\link{get_artist_songs}} to return data in full as a
list.

Other artist: 
\code{\link{get_artist_df}()},
\code{\link{get_artist_songs}()},
\code{\link{get_artist}()}
}
\concept{artist}
