% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/albums.R
\name{tidy_album_performances}
\alias{tidy_album_performances}
\title{Extract album performances from a Genius album}
\usage{
tidy_album_performances(x)
}
\arguments{
\item{x}{A \code{genius_album} object}
}
\value{
a tibble
}
\description{
Extract "album performances" (i.e. album credits) info from a Genius album object,
as a tidy tibble.
}
\examples{
\dontrun{
album <- get_album(album_id = 337082)

tidy_album_performances(album)
}

}
\seealso{
See \code{\link{get_album}} to generate a Genius album object.

Other song: 
\code{\link{get_song_df}()},
\code{\link{get_song}()},
\code{\link{tidy_song_performances}()},
\code{\link{tidy_song_producers}()},
\code{\link{tidy_song_relationships}()},
\code{\link{tidy_song_writers}()}
}
\concept{song}
