% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_effect_size_functions.R
\name{es.calc.linear}
\alias{es.calc.linear}
\title{Function to Calculate Effect Size for Linear Models}
\usage{
es.calc.linear(power = NULL, N = NULL, MAF = NULL, sd_y = NULL,
  Alpha = 0.05, True.Model = "All", Test.Model = "All")
}
\arguments{
\item{power}{Vector of the desired power(s)}

\item{N}{Vector of the desired sample size(s)}

\item{MAF}{Vector of minor allele frequencies}

\item{sd_y}{Standard deviation of the outcome in the population (ignoring genotype). Either sd_y_x or sd_y must be specified.}

\item{Alpha}{the desired type 1 error rate(s)}

\item{True.Model}{A vector specifying the true underlying genetic model(s): 'Dominant', 'Additive', 'Recessive' or 'All'}

\item{Test.Model}{A vector specifying the assumed genetic model(s) used in testing: 'Dominant', 'Additive', 'Recessive' or 'All'}
}
\value{
A data frame including the power for all combinations of the specified parameters (Case.Rate, ES, Power, etc)
}
\description{
Calculates the detectable effect size/regression coefficient, at a given sample size, N, and power, with type 1 error rate, Alpha
}
\examples{
es <- es.calc.linear(N=1000,power=0.8,
    MAF=0.1, sd_y = 1, Alpha=0.05,
    True.Model='All', Test.Model='All')

}
