% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Score_init.R
\name{find_max_ind}
\alias{find_max_ind}
\title{Finds the max index in a vector that does not exceed a target number.}
\usage{
find_max_ind(vals, target, start = 1)
}
\arguments{
\item{vals}{A vector of numbers.}

\item{target}{A number. Must not be smaller than \code{vals[start]}.}

\item{start}{A number, the starting index; default to 1. Must be such that \code{vals[start] <= target}.}
}
\value{
The max index \code{i} such that \code{vals[i] <= target} and \code{i >= start}.
}
\description{
Finds the max index in a vector that does not exceed a target number.
}
\examples{
for (i in 1:100) {
   vals <- 1:i
   for (start in 1:i)
      for (target in seq(start, i+0.5, by=0.5))
         if (find_max_ind(vals, target, start) != floor(target))
            stop()
}
}
