% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_pathways.R
\name{pathway_to_cell_signature}
\alias{pathway_to_cell_signature}
\title{Pathway to Cell Signature}
\usage{
pathway_to_cell_signature(
  queryValues = NULL,
  pathway_ids = NULL,
  options = list(timeout = 10000)
)
}
\arguments{
\item{queryValues}{A vector of query values to search for pathways. Optional if
\code{pathway_ids} is provided.}

\item{pathway_ids}{A vector of pathway IDs to be used directly. Optional if \code{queryValues}
is provided.}

\item{options}{A list of options for the API call, including endpoint and timeout settings.}
}
\value{
A data frame of unique effect sizes, filtered by a foldChange threshold and
deduplicated by cell_id.
}
\description{
This function queries for pathways based on given values, fetches genes associated with
those pathways, and filters for unique cell identifiers based on specified criteria. If
pathway IDs are already known, they can be directly provided to skip the query step.
}
\examples{
\dontrun{
pathway_to_cell_signature(
  queryValues = c("Adaptive Immune System"), 
  options = list(timeout = 10000)
)
}
}
