% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/arcdist.R
\name{arcdist}
\alias{arcdist}
\title{Geographical distance computations}
\usage{
arcdist(lat, lon, lat1 = NULL, lon1 = NULL, scale = "nmi")
}
\arguments{
\item{lat}{Latitude of first coordinate or list with lat, lon of first
coordinate.}

\item{lon}{Longitude of first coordinate or list with lat, lon of second
coordinate.}

\item{lat1,lon1}{If lat and lon are vectors of lat,lon positions, then lat1
and lon1 must be given as the second set of positions.}

\item{scale}{\code{nmi} returns value in nautical miles, any other value in
kilometers}
}
\value{
A single vector of distances between pairs of points is returned
}
\description{
Computes distances between lat/lon data points.
}
\examples{
pos1 <- list(lat = c(65, 66), lon = c(-19, -20))
  pos2 <- list(lat = c(64, 65), lon = c(-19, -20))
  dists <- arcdist(pos1, pos2)         # pos1 and pos2 are lists of coordinates.
  lat <- c(65, 66)
  lon <- c(-19, -20)
  lat1 <- c(64, 65)
  lon1 <- c(-19, -20)
  dists <- arcdist(lat, lon, lat1, lon1) # Input in vector format.
}
\seealso{
\code{\link{geoplot}}, \code{\link{geotext}}, \code{\link{selpos}},
}

