% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{mcstrga}
\alias{mcstrga}
\title{MCMC samples from the transformed Gaussian model}
\usage{
mcstrga(formula, data, weights, subset, atsample, Nout, Nthin = 1, Nbi = 0,
  betm0, betQ0, ssqdf, ssqsc, tsqdf, tsqsc, phipars, omgpars,
  corrfcn = c("matern", "spherical", "powerexponential"), kappa, linkp, phisc,
  omgsc, zstart, phistart, omgstart, longlat = FALSE, test = FALSE)
}
\arguments{
\item{formula}{A representation of the model in the form
\code{response ~ terms}. The response must be set to \code{NA}'s
at the prediction locations (see the example in
\code{\link{mcsglmm}} for how to do this using
\code{\link{stackdata}}). At the observed locations the response
is assumed to be a total of replicated measurements. The number of
replications is inputted using the argument \code{weights}.}

\item{data}{An optional data frame containing the variables in the
model.}

\item{weights}{An optional vector of weights. Number of replicated
samples.}

\item{subset}{An optional vector specifying a subset of
observations to be used in the fitting process.}

\item{atsample}{A formula in the form \code{~ x1 + x2 + ... + xd}
with the coordinates of the sampled locations.}

\item{Nout}{Number of MCMC samples to return.}

\item{Nthin}{The thinning of the MCMC algorithm.}

\item{Nbi}{The burn-in of the MCMC algorithm.}

\item{betm0}{Prior mean for beta (a vector or scalar).}

\item{betQ0}{Prior standardised precision (inverse variance)
matrix.}

\item{ssqdf}{Degrees of freedom for the scaled inverse chi-square
prior for the partial sill parameter.}

\item{ssqsc}{Scale for the scaled inverse chi-square prior for the
partial sill parameter.}

\item{tsqdf}{Degrees of freedom for the scaled inverse chi-square
prior for the measurement error parameter.}

\item{tsqsc}{Scale for the scaled inverse chi-square prior for the
measurement error parameter.}

\item{phipars}{Parameters for the generalized inverse gamma prior
for the range parameter \code{phi}. A four dimensional vector with
parameters scale, shape, exponent, location in that order. See
\code{\link{mcsglmm}}.}

\item{omgpars}{Parameters for the generalized inverse gamma prior
for the relative nugget parameter \code{omg}. A four dimensional
vector with parameters scale, shape, exponent, location in that
order. See \code{\link{mcsglmm}}.}

\item{corrfcn}{Spatial correlation function. See
\code{\link{ebsglmm}} for details.}

\item{kappa}{Spatial correlation parameter. Smoothness parameter
for Matern, exponent for the power family.}

\item{linkp}{The exponent of the Box-Cox transformation.}

\item{phisc}{Random walk parameter for \code{phi}. Smaller values
increase the acceptance ratio. Set this to 0 for fixed \code{phi}.
In this case the fixed value is given in the argument
\code{phistart}.}

\item{omgsc}{Random walk parameter for \code{omg}. Smaller values
increase the acceptance ratio. Set this to 0 for fixed \code{omg}.
In this case the fixed value is given in the argument
\code{omgstart}.}

\item{zstart}{Optional starting value for the MCMC for the GRF.
This can be either a scalar, a vector of size n where n is the
number of sampled locations.}

\item{phistart}{Optional starting value for the MCMC for the
spatial range parameter \code{phi}. Defaults to the mean of its
prior. If \code{phisc} is 0, then this argument is required and it
corresponds to the fixed value of \code{phi}.}

\item{omgstart}{Optional starting value for the MCMC for the relative
nugget parameter \code{omg}. Defaults to the mean of its prior. If
\code{omgsc} is 0, then this argument is required and
itcorresponds to the fixed value of \code{omg}.}

\item{longlat}{How to compute the distance between locations. If
\code{FALSE}, Euclidean distance, if \code{TRUE} Great Circle
distance. See \code{\link[sp]{spDists}}.}

\item{test}{Whether this is a trial run to monitor the acceptance
ratio of the random walk for \code{phi} and \code{omg}. If set to
\code{TRUE}, the acceptance ratio will be printed on the screen
every 100 iterations of the MCMC. Tune the \code{phisc} and
\code{omgsc} parameters in order to achive 20 to 30\% acceptance.
Set this to a positive number to change the default 100. No
thinning or burn-in are done when testing.}
}
\value{
A list containing the MCMC samples and other variables as
follows:
\itemize{
 \item \code{z} A matrix containing the MCMC samples for the
spatial random field. Each column is one sample.
 \item \code{beta} A matrix containing the MCMC samples for the
regressor coefficients. Each column is one sample.
 \item \code{ssq} A vector with the MCMC samples for the partial
 \item \code{tsq} A vector with the MCMC samples for the
measurement error variance.
 \item \code{phi} A vector with the MCMC samples for the spatial
range parameter.
 \item \code{omg} A vector with the MCMC samples for the relative
nugget parameter.
 \item \code{nu} The link function parameter translated to
numeric code used internally.
 \item \code{logLik} A vector containing the value of the
log-likelihood evaluated at each sample.
 \item \code{acc_ratio} The acceptance ratio for the joint update
of the parameters \code{phi} and \code{omg}.
 \item \code{sys_time} The total computing time for the MCMC sampling.
 \item \code{Nout}, \code{Nbi},  \code{Nthin} As in input. Used
internally in other functions.
 \item \code{response} The value of the response variable at the
observed locations. Used internally in other functions.
 \item \code{weights} The response weights at the observed
locations. Used internally in other functions.
 \item \code{modelmatrix} The model matrix at the observed
locations. Used internally in other functions.
 \item \code{family} As in input. Used internally in other functions.
 \item \code{betm0}, \code{betQ0}, \code{ssqdf}, \code{ssqsc},
\code{corrfcn}, \code{kappa}, \code{tsqdf}, \code{tsqsc} As in
input. Used internally in other functions.
 \item \code{locations} Coordinates of the observed locations.
Used internally in other functions.
 \item \code{whichobs} A logical vector indicated which rows in
the data and in the MCMC samples for the spatial random field
correspond to the observed locations.
}
}
\description{
Draw MCMC samples from the transformed Gaussian model with known
link function
}
\details{
Simulates from the posterior distribution of this model.
}
\examples{
\dontrun{
### Load the data
data(rhizoctonia)
rhiz <- na.omit(rhizoctonia)
rhiz$IR <- rhiz$Infected/rhiz$Total # Incidence rate of the
                              # rhizoctonia disease

### Define the model
corrf <- "spherical"
ssqdf <- 1
ssqsc <- 1
tsqdf <- 1
tsqsc <- 1
betm0 <- 0
betQ0 <- diag(.01, 2, 2)
phiprior <- c(200, 1, 1000, 100) # U(100, 300)
phisc <- 1
omgprior <- c(3, 1, 1000, 0) # U(0, 3)
omgsc <- 1.3
linkp <- 1

## MCMC parameters
Nout <- 100
Nbi <- 0
Nthin <- 1

samplt <- mcstrga(Yield ~ IR, data = rhiz,
                  atsample = ~ Xcoord + Ycoord, corrf = corrf,
                  Nout = Nout, Nthin = Nthin,
                  Nbi = Nbi, betm0 = betm0, betQ0 = betQ0,
                  ssqdf = ssqdf, ssqsc = ssqsc,
                  tsqdf = tsqdf, tsqsc = tsqsc,
                  phipars = phiprior, omgpars = omgprior,
                  linkp = linkp,
                  phisc = phisc, omgsc = omgsc, test=10)

sample <- mcstrga(Yield ~ IR, data = rhiz,
                  atsample = ~ Xcoord + Ycoord, corrf = corrf,
                  Nout = Nout, Nthin = Nthin,
                  Nbi = Nbi, betm0 = betm0, betQ0 = betQ0,
                  ssqdf = ssqdf, ssqsc = ssqsc,
                  tsqdf = tsqdf, tsqsc = tsqsc,
                  phipars = phiprior, omgpars = omgprior,
                  linkp = linkp,
                  phisc = phisc, omgsc = omgsc, test=FALSE)
}
}

