% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pop_arrangements.R
\name{read_pop_arrangements}
\alias{read_pop_arrangements}
\title{Download population arrangements in Brazil}
\usage{
read_pop_arrangements(year = 2015, simplified = TRUE, showProgress = TRUE)
}
\arguments{
\item{year}{A year number in YYYY format. Defaults to \code{2015}}

\item{simplified}{Logic \code{FALSE} or \code{TRUE}, indicating whether the function returns
the data set with 'original' resolution or a data set with 'simplified' borders.
Defaults to \code{TRUE}. For spatial analysis and statistics users should set
\code{simplified = FALSE}. Borders have been simplified by removing vertices of
borders using \verb{st_simplify\{sf\}} preserving topology with a \code{dTolerance} of 100.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
This function reads the official data on population arrangements (Arranjos
Populacionais) of Brazil. Original data were generated by the Institute of
Geography and Statistics (IBGE)  For more information about the methodology,
see details at \url{https://www.ibge.gov.br/apps/arranjos_populacionais/2015/pdf/publicacao.pdf}
}
\examples{
\dontrun{ if (interactive()) {
# Read urban footprint of Brazilian cities in an specific year
uc <- read_pop_arrangements(year=2015)
} }
}
