% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup_muni.R
\name{lookup_muni}
\alias{lookup_muni}
\title{Look up municipality codes and names}
\usage{
lookup_muni(name_muni = NULL, code_muni = NULL)
}
\arguments{
\item{name_muni}{The municipality name to be looked up.}

\item{code_muni}{The municipality code to be looked up.}
}
\value{
A \code{data.frame} with 13 columns identifying the geographies information
of that municipality.

A \code{data.frame}
}
\description{
Input a municipality \strong{name} \emph{or} \strong{code} and get the names
and codes of the municipality's corresponding state, meso, micro, intermediate,
and immediate regions
}
\details{
Only available from 2010 Census data so far
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get lookup table for municipality Rio de Janeiro
mun <- lookup_muni(name_muni = "Rio de Janeiro")

# Or you can get a lookup table for the same municipality searching for its code
mun <- lookup_muni(code_muni = 3304557)

# Get lookup table for all municipalities
mun_all <- lookup_muni(name_muni = "all")

# Or:
mun_all <- lookup_muni(code_muni = "all")
\dontshow{\}) # examplesIf}
}
\seealso{
Other support functions: 
\code{\link{list_geobr}()}
}
\concept{support functions}
