% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_obs_dens.R
\name{get_obs_dens}
\alias{get_obs_dens}
\title{Generate observed densities}
\usage{
get_obs_dens(hfr, dep_var, indep_var, ngrid = 100, window)
}
\arguments{
\item{hfr}{hyperframe}

\item{dep_var}{The name of the dependent variable.
Since we need to obtain the observed density of treatment events,
`dep_var` should be the name of the treatment variable.}

\item{indep_var}{vector of names of independent variables (covariates)}

\item{ngrid}{the number of grid cells that is used to generate observed densities.
By default = 100. Notice that as you increase `ngrid`, the process gets computationally demanding.}

\item{window}{owin object}
}
\value{
list of the following:
     * `indep_var`: independent variables
     * `coef`: coefficients
     * `intens_grid_cells`: im object of observed densities for each time period
     * `estimated_counts`: the number of events that is estimated by the poisson point process model for each time period
     * `sum_log_intens`: the sum of log intensities for each time period
}
\description{
`get_obs_dens()` takes a hyperframe and returns observed densities.
The output is used as propensity scores.
}
\details{
`get_obs_dens()` assumes the poisson point process model and
calculates observed densities for each time period. It depends on `spatstat.model::mppm()`.
Users should note that the coefficients in the output are not directly interpretable,
since they are the coefficients inside the exponential of the poisson model.
}
\examples{
# Data
dat_out <- insurgencies[1:100, ]
dat_out$time <- as.numeric(dat_out$date - min(dat_out$date) + 1)

# Hyperframe
dat_hfr <- get_hfr(data = dat_out,
                   subtype_column = "type",
                   window = iraq_window,
                   time_column = "time",
                   time_range = c(1, max(dat_out$time)),
                   coordinates = c("longitude", "latitude"),
                   combined = TRUE)

# Covariates
dist_baghdad <- get_dist_focus(window = iraq_window,
                               longitude = c(44.366), #Baghdad
                               latitude = c(33.315),
                               resolution = 0.1,
                               grayscale = FALSE,
                               mile = FALSE,
                               preprocess = FALSE)

dat_hfr$dist_bagh <- dist_baghdad$distance_im

# Observed density
get_obs_dens(dat_hfr,
             dep_var = "all_combined",
             indep_var = c("dist_bagh"),
             ngrid = 100, 
             window = iraq_window)
}
