% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_indices.R
\name{calcFuzzyELSA}
\alias{calcFuzzyELSA}
\title{calculate ELSA statistic for a fuzzy partition}
\usage{
calcFuzzyELSA(object, nblistw = NULL, window = NULL, matdist = NULL)
}
\arguments{
\item{object}{A FCMres object, typically obtained from functions CMeans,
GCMeans, SFCMeans, SGFCMeans. Can also be a membership matrix. Each row of this matrix
must sum up to 1. Can also be a list of rasters, in which case each raster must represent
the membership values for one cluster and the sum of all the rasters must be a raster filled
with ones.}

\item{nblistw}{A list.w object describing the neighbours typically produced
by the spdep package. Required if data is a dataframe, see the parameter window
if you use a list of rasters as input.}

\item{window}{A binary (0,1) matrix representing the neighbours spatial weights when working
with rasters. The matrix must have odd dimensions.}

\item{matdist}{A matrix representing the dissimilarity between the clusters. The matrix must
be squared and the diagonal must be filled with zeros.}
}
\value{
either a vector or a raster with the ELSA values.
}
\description{
Calculate ELSA statistic for a fuzzy partition. This local indicator of
spatial autocorrelation can be used to identify areas where close observations tend to
belong to different clusters.
}
\details{
The fuzzy ELSA index is a generalization of the ELSA index \insertCite{naimi2019elsa}{geocmeans}. It can be used to measure
local autocorrelation for a membership matrix. It varies between 0 and 1, 0 indicating
a perfect positive spatial autocorrelation and 1 a perfect heterogeneity. It is based on
the Shannon entropy index, and uses a measure of dissimilarity between categories.
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- sf::st_drop_geometry(LyonIris[AnalysisFields])
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
elsa_valus <- calcFuzzyELSA(result)
}
